/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import net.minecraftforge.energy.IEnergyStorage;

public class CombinedEnergyStorage
implements IEnergyStorage {
    IEnergyStorage[] storages;

    public CombinedEnergyStorage(IEnergyStorage ... storages) {
        this.storages = storages;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = 0;
        int rest = maxReceive;
        for (IEnergyStorage e : this.storages) {
            if (received == maxReceive || rest == 0) break;
            int r = e.receiveEnergy(rest, simulate);
            received += r;
            rest -= r;
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = 0;
        int rest = maxExtract;
        for (IEnergyStorage e : this.storages) {
            if (extracted == maxExtract || rest == 0) break;
            int r = e.extractEnergy(rest, simulate);
            extracted += r;
            rest -= r;
        }
        return extracted;
    }

    public int getEnergyStored() {
        int i = 0;
        for (IEnergyStorage e : this.storages) {
            i += e.getEnergyStored();
        }
        return i;
    }

    public int getMaxEnergyStored() {
        int i = 0;
        for (IEnergyStorage e : this.storages) {
            i += e.getMaxEnergyStored();
        }
        return i;
    }

    public boolean canExtract() {
        return this.extractEnergy(1, true) > 0;
    }

    public boolean canReceive() {
        return this.receiveEnergy(1, true) > 0;
    }
}

