/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import java.awt.Color;
import java.util.stream.Collectors;
import mrriegel.limelib.Config;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.datapart.DataPartRegistry;
import mrriegel.limelib.datapart.RenderRegistry;
import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.helper.ColorHelper;
import mrriegel.limelib.helper.EnergyHelper;
import mrriegel.limelib.helper.ParticleHelper;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.network.PlayerClickMessage;
import mrriegel.limelib.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientEventHandler {
    public static DataPart rayTrace = null;

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent event) {
        event.getMap().func_174942_a(ParticleHelper.roundParticle);
        event.getMap().func_174942_a(ParticleHelper.sparkleParticle);
        event.getMap().func_174942_a(ParticleHelper.squareParticle);
    }

    @SubscribeEvent
    public static void renderEnergy(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Config.showEnergy || mc == null || mc.field_71441_e == null || mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK || mc.field_71476_x.func_178782_a() == null || mc.field_71441_e.func_175625_s(mc.field_71476_x.func_178782_a()) == null || LimeLib.proxy.energyTiles().isEmpty()) {
            return;
        }
        BlockPos p = mc.field_71476_x.func_178782_a();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && LimeLib.proxy.energyTiles().containsKey(p)) {
            EnergyHelper.Energy energyType = EnergyHelper.isEnergyContainer((ICapabilityProvider)mc.field_71441_e.func_175625_s(p), null);
            if (energyType == null) {
                LimeLib.proxy.energyTiles().remove(p);
                return;
            }
            ScaledResolution sr = event.getResolution();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GuiDrawer drawer = new GuiDrawer(0, 0, 0, 0, 0.0f);
            long energy = (Long)LimeLib.proxy.energyTiles().get(p).getLeft();
            long max = (Long)LimeLib.proxy.energyTiles().get(p).getRight();
            String text = (!GuiScreen.func_146272_n() ? Utils.formatNumber(energy) : Long.valueOf(energy)) + "/" + (!GuiScreen.func_146272_n() ? Utils.formatNumber(max) : Long.valueOf(max)) + " " + energyType.unit;
            int lenght = 90;
            mc.field_71466_p.func_175065_a(text, (float)((sr.func_78326_a() - mc.field_71466_p.func_78256_a(text)) / 2), (float)((sr.func_78328_b() - 15 - mc.field_71466_p.field_78288_b) / 2), GuiScreen.func_146272_n() ? 0xFFFF00 : -2130706688, true);
            if (Config.energyConfigHint) {
                boolean before = mc.field_71466_p.func_82883_a();
                mc.field_71466_p.func_78264_a(true);
                String config = "Can be disabled in LimeLib config.";
                mc.field_71466_p.func_175065_a(config, (float)((sr.func_78326_a() - mc.field_71466_p.func_78256_a(config)) / 2), (float)((sr.func_78328_b() + 40 - mc.field_71466_p.field_78288_b) / 2), 0x40FFFF00, true);
                mc.field_71466_p.func_78264_a(before);
            }
            drawer.drawEnergyBarH((sr.func_78326_a() - lenght) / 2, (sr.func_78328_b() + 20 - 8) / 2, lenght, (float)((double)energy / (double)max));
            drawer.drawFrame((sr.func_78326_a() - lenght) / 2 - 1, (sr.func_78328_b() + 20 - 8) / 2 - 1, lenght + 2, 9, 1, ColorHelper.darker(Color.RED.getRGB(), 0.8));
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null && !mc.func_147113_T()) {
            DataPartRegistry reg = DataPartRegistry.get((World)mc.field_71441_e);
            if (reg != null) {
                for (DataPart part : reg.getParts().stream().filter(p -> p != null && mc.field_71441_e.func_175667_e(p.getPos())).collect(Collectors.toList())) {
                    part.updateClient((World)mc.field_71441_e);
                    ++part.ticksExisted;
                }
            }
            if (mc.field_71439_g != null && mc.field_71439_g.field_70173_aa % 2 == 0) {
                rayTrace = DataPart.rayTrace((EntityPlayer)mc.field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        DataPartRegistry reg = DataPartRegistry.get((World)Minecraft.func_71410_x().field_71441_e);
        if (reg != null) {
            for (DataPart p2 : reg.getParts().stream().filter(p -> p != null && Minecraft.func_71410_x().field_71439_g.func_70011_f((double)p.getX(), (double)p.getY(), (double)p.getZ()) < 64.0).collect(Collectors.toList())) {
                RenderRegistry.RenderDataPart<? extends DataPart> ren = RenderRegistry.map.get(p2.getClass());
                if (ren == null) continue;
                ren.render(p2, (double)p2.getX() - TileEntityRendererDispatcher.field_147554_b, (double)p2.getY() - TileEntityRendererDispatcher.field_147555_c, (double)p2.getZ() - TileEntityRendererDispatcher.field_147552_d, event.getPartialTicks());
            }
        }
    }

    public static void click(MouseEvent event) {
        DataPart part;
        Minecraft mc = Minecraft.func_71410_x();
        if (!(!mc.field_71415_G || mc.func_147113_T() || !event.isButtonstate() || event.isCanceled() || event.getButton() != 0 && event.getButton() != 1 || (part = DataPart.rayTrace((EntityPlayer)mc.field_71439_g)) == null || mc.field_71439_g.func_70093_af())) {
            boolean touch = false;
            EnumHand hand = EnumHand.MAIN_HAND;
            PacketHandler.sendToServer(new PlayerClickMessage(part.getPos(), hand, event.getButton() == 0));
            touch = event.getButton() == 0 ? part.onLeftClicked((EntityPlayer)mc.field_71439_g, hand) : part.onRightClicked((EntityPlayer)mc.field_71439_g, hand);
            mc.field_71439_g.func_184609_a(hand);
            if (!touch) {
                return;
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void draw(DrawBlockHighlightEvent event) {
        DataPart part = rayTrace;
        if (part != null && part.getHighlightBox() != null) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos blockpos = part.getPos();
            double d0 = TileEntityRendererDispatcher.field_147554_b;
            double d1 = TileEntityRendererDispatcher.field_147555_c;
            double d2 = TileEntityRendererDispatcher.field_147552_d;
            RenderGlobal.func_189697_a((AxisAlignedBB)part.getHighlightBox().func_186670_a(blockpos).func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }
}

