/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.tile;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.helper.NBTHelper;
import mrriegel.limelib.tile.CommonTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CommonTileInventory
extends CommonTile
implements IInventory {
    protected ItemStack[] stacks;
    public final int SIZE;
    public final int STACKLIMIT;

    public CommonTileInventory(int size) {
        this(size, 64);
    }

    public CommonTileInventory(int size, int limit) {
        this.SIZE = size;
        this.STACKLIMIT = limit;
        Object[] ar = new ItemStack[this.SIZE];
        Arrays.fill(ar, null);
        this.stacks = ar;
    }

    public String func_70005_c_() {
        return "null";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.SIZE;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.stacks, (int)index, (int)count);
        if (itemstack == null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a((ItemStack[])this.stacks, (int)index);
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
            LimeLib.log.warn("Size of itemstack is too high for inventory.");
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.STACKLIMIT;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        Arrays.fill(this.stacks, null);
    }

    @Override
    public List<ItemStack> getDroppingItems() {
        return Lists.newArrayList((Object[])this.stacks);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this instanceof ISidedInventory) {
                return (T)new SidedInvWrapper((ISidedInventory)this, facing);
            }
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        List<ItemStack> lis = NBTHelper.getItemStackList(compound, "Items");
        for (int i = 0; i < lis.size(); ++i) {
            this.stacks[i] = lis.get(i);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTHelper.setItemStackList(compound, "Items", Lists.newArrayList((Object[])this.stacks));
        return super.func_189515_b(compound);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player);
    }
}

