/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mrriegel.limelib.helper.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

public class ShapelessRecipeExt
implements IRecipe {
    @Nonnull
    protected ItemStack output = null;
    protected List<Object> input = Lists.newArrayList();

    public ShapelessRecipeExt(@Nonnull ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            if (in instanceof List) {
                StackHelper.toStackList((List)in);
                this.input.add(in);
                continue;
            }
            throw new RuntimeException("wrong input");
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList required = Lists.newArrayList();
        required.addAll(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        Object nex = itr.next();
                        if (nex instanceof ItemStack) {
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)nex), (ItemStack)slot, (boolean)false);
                            continue;
                        }
                        if (nex instanceof Item) {
                            match = slot.func_77973_b() == nex;
                            continue;
                        }
                        if (!(nex instanceof Block)) continue;
                        match = slot.func_77973_b() == Item.func_150898_a((Block)((Block)nex));
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public List<Object> getInput() {
        return this.input;
    }

    @Nonnull
    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    static {
        RecipeSorter.register((String)"limelib:shapelessExt", ShapelessRecipeExt.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }
}

