/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import mrriegel.limelib.network.AbstractMessage;
import mrriegel.limelib.network.DataPartSyncMessage;
import mrriegel.limelib.network.EnergySyncMessage;
import mrriegel.limelib.network.OpenGuiMessage;
import mrriegel.limelib.network.PlayerClickMessage;
import mrriegel.limelib.network.TeleportMessage;
import mrriegel.limelib.network.TileGuiMessage;
import mrriegel.limelib.network.TileMessage;
import mrriegel.limelib.network.TileSyncMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public static SimpleNetworkWrapper wrapper;
    private static int index;
    private static boolean defaultsRegistered;
    private static Map<Side, Set<Class<? extends AbstractMessage<?>>>> registered;

    private PacketHandler() {
    }

    public static void init() {
        if (wrapper == null) {
            wrapper = new SimpleNetworkWrapper("LimeLib");
        }
        PacketHandler.registerDefaults();
    }

    private static void registerDefaults() {
        if (defaultsRegistered) {
            return;
        }
        defaultsRegistered = true;
        PacketHandler.registerMessage(TileMessage.class, Side.SERVER);
        PacketHandler.registerMessage(TileGuiMessage.class, Side.SERVER);
        PacketHandler.registerMessage(TileSyncMessage.class);
        PacketHandler.registerMessage(TeleportMessage.class, Side.CLIENT);
        PacketHandler.registerMessage(EnergySyncMessage.class, Side.CLIENT);
        PacketHandler.registerMessage(DataPartSyncMessage.class, Side.CLIENT);
        PacketHandler.registerMessage(OpenGuiMessage.class, Side.SERVER);
        PacketHandler.registerMessage(PlayerClickMessage.class, Side.SERVER);
    }

    public static <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends AbstractMessage<?>> classMessage, Side side) {
        Class<? extends AbstractMessage<?>> c1 = classMessage;
        Class<? extends AbstractMessage<?>> c2 = classMessage;
        PacketHandler.registerMessage(c1, c2, side);
        if (registered.get(side) == null) {
            registered.put(side, Sets.newHashSet());
        }
        registered.get(side).add(classMessage);
    }

    public static <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends AbstractMessage<?>> classMessage) {
        PacketHandler.registerMessage(classMessage, Side.CLIENT);
        PacketHandler.registerMessage(classMessage, Side.SERVER);
    }

    public static <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        PacketHandler.init();
        wrapper.registerMessage(messageHandler, requestMessageType, index++, side);
    }

    public static boolean isRegistered(Class<? extends AbstractMessage<?>> classMessage, Side side) {
        return registered.get(side).contains(classMessage);
    }

    public static void sendToAll(IMessage message) {
        PacketHandler.init();
        wrapper.sendToAll(message);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        PacketHandler.init();
        wrapper.sendTo(message, player);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        PacketHandler.init();
        wrapper.sendToAllAround(message, point);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        PacketHandler.init();
        wrapper.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        PacketHandler.init();
        wrapper.sendToServer(message);
    }

    static {
        index = 0;
        defaultsRegistered = false;
        registered = Maps.newHashMap();
    }
}

