/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.network;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.datapart.DataPartRegistry;
import mrriegel.limelib.helper.NBTHelper;
import mrriegel.limelib.network.AbstractMessage;
import mrriegel.limelib.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class DataPartSyncMessage
extends AbstractMessage<DataPartSyncMessage> {
    public DataPartSyncMessage() {
    }

    public DataPartSyncMessage(DataPart part, BlockPos pos, List<BlockPos> parts) {
        if (part == null) {
            this.nbt.func_74757_a("removed", true);
            this.nbt.func_74772_a("poS", pos.func_177986_g());
        } else {
            part.writeDataToNBT(this.nbt);
        }
        NBTHelper.setLongList(this.nbt, "poss", Utils.getLongList(parts));
    }

    @Override
    public void handleMessage(EntityPlayer player, NBTTagCompound nbt, Side side) {
        BlockPos pos = BlockPos.func_177969_a((long)NBTHelper.getLong(nbt, "poS"));
        DataPartRegistry reg = DataPartRegistry.get(player.field_70170_p);
        if (reg != null) {
            if (nbt.func_74767_n("removed")) {
                reg.removeDataPart(pos);
            } else {
                DataPart p2 = reg.getDataPart(pos);
                if (p2 != null) {
                    p2.setWorld(player.field_70170_p);
                    p2.readDataFromNBT(nbt);
                } else {
                    reg.createPart(nbt);
                }
            }
            List<BlockPos> valids = Utils.getBlockPosList(NBTHelper.getLongList(nbt, "poss"));
            Set<BlockPos> clients = reg.getParts().stream().map(DataPart::getPos).collect(Collectors.toSet());
            clients.removeAll(valids);
            clients.forEach(p -> reg.removeDataPart((BlockPos)p));
        }
    }
}

