/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.jei;

import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.recipe.ShapelessRecipeExt;
import net.minecraft.item.ItemStack;

public class ShapelessRecipeExtHandler
extends BlankRecipeWrapper
implements IRecipeHandler<ShapelessRecipeExt> {
    private IJeiHelpers jeiHelpers;
    private ShapelessRecipeExt recipe;

    public ShapelessRecipeExtHandler(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    public Class<ShapelessRecipeExt> getRecipeClass() {
        return ShapelessRecipeExt.class;
    }

    public String getRecipeCategoryUid(ShapelessRecipeExt recipe) {
        return "minecraft.crafting";
    }

    public IRecipeWrapper getRecipeWrapper(ShapelessRecipeExt recipe) {
        ShapelessRecipeExtHandler wrap = new ShapelessRecipeExtHandler(this.jeiHelpers);
        wrap.recipe = recipe;
        return wrap;
    }

    public boolean isRecipeValid(ShapelessRecipeExt recipe) {
        if (recipe.func_77571_b() == null) {
            LimeLib.log.error("Recipe has no outputs. {}");
            return false;
        }
        int inputCount = 0;
        for (Object input : recipe.getInput()) {
            if (input instanceof List && ((List)input).isEmpty()) {
                return false;
            }
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount > 9) {
            LimeLib.log.error("Recipe has too many inputs. {}");
            return false;
        }
        if (inputCount == 0) {
            LimeLib.log.error("Recipe has no inputs. {}");
            return false;
        }
        return true;
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        ItemStack recipeOutput = this.recipe.func_77571_b();
        List inputs = stackHelper.expandRecipeItemStackInputs(this.recipe.getInput());
        ingredients.setInputLists(ItemStack.class, inputs);
        if (recipeOutput != null) {
            ingredients.setOutput(ItemStack.class, (Object)recipeOutput);
        }
    }

    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }
}

