/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.jei;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.recipe.ShapedRecipeExt;
import net.minecraft.item.ItemStack;

public class ShapedRecipeExtHandler
extends BlankRecipeWrapper
implements IRecipeHandler<ShapedRecipeExt>,
IShapedCraftingRecipeWrapper {
    private IJeiHelpers jeiHelpers;
    private ShapedRecipeExt recipe;

    public ShapedRecipeExtHandler(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    public Class<ShapedRecipeExt> getRecipeClass() {
        return ShapedRecipeExt.class;
    }

    public String getRecipeCategoryUid(ShapedRecipeExt recipe) {
        return "minecraft.crafting";
    }

    public IRecipeWrapper getRecipeWrapper(ShapedRecipeExt recipe) {
        ShapedRecipeExtHandler wrap = new ShapedRecipeExtHandler(this.jeiHelpers);
        wrap.recipe = recipe;
        return wrap;
    }

    public boolean isRecipeValid(ShapedRecipeExt recipe) {
        if (recipe.func_77571_b() == null) {
            LimeLib.log.error("Recipe has no outputs. {}");
            return false;
        }
        int inputCount = 0;
        for (Object input : recipe.getInput()) {
            if (input instanceof List && ((List)input).isEmpty()) {
                return false;
            }
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount > 9) {
            LimeLib.log.error("Recipe has too many inputs. {}");
            return false;
        }
        if (inputCount == 0) {
            LimeLib.log.error("Recipe has no inputs. {}");
            return false;
        }
        return true;
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        ItemStack recipeOutput = this.recipe.func_77571_b();
        List inputs = stackHelper.expandRecipeItemStackInputs(Arrays.asList(this.recipe.getInput()));
        ingredients.setInputLists(ItemStack.class, inputs);
        ingredients.setOutput(ItemStack.class, (Object)recipeOutput);
    }

    public int getWidth() {
        return this.recipe.getWidth();
    }

    public int getHeight() {
        return this.recipe.getHeight();
    }

    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }
}

