/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.jei;

import com.google.common.collect.Lists;
import java.util.List;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeHandler;
import mrriegel.limelib.jei.ShapedRecipeExtHandler;
import mrriegel.limelib.jei.ShapelessRecipeExtHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class JEI
extends BlankModPlugin {
    private static IJeiRuntime runtime;

    public void register(IModRegistry registry) {
        registry.addRecipeHandlers(new IRecipeHandler[]{new ShapedRecipeExtHandler(registry.getJeiHelpers())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ShapelessRecipeExtHandler(registry.getJeiHelpers())});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static IJeiRuntime getRuntime() {
        return runtime;
    }

    public static void showRecipes(ItemStack stack) {
        JEI.showRecipes((Object)stack);
    }

    public static void showUsage(ItemStack stack) {
        JEI.showUsage((Object)stack);
    }

    public static void showRecipes(FluidStack stack) {
        JEI.showRecipes((Object)stack);
    }

    public static void showUsage(FluidStack stack) {
        JEI.showUsage((Object)stack);
    }

    private static void showRecipes(Object stack) {
        runtime.getRecipesGui().show(runtime.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, stack));
    }

    private static void showUsage(Object stack) {
        runtime.getRecipesGui().show(runtime.getRecipeRegistry().createFocus(IFocus.Mode.INPUT, stack));
    }

    public static void showCategories(List<String> strings) {
        runtime.getRecipesGui().showCategories(strings);
    }

    public static void showCategories(String string) {
        JEI.showCategories(Lists.newArrayList((Object[])new String[]{string}));
    }
}

