/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldHelper {
    public static void addOreSpawn(IBlockState state, World world, int veinPerChunk, int size, int chunkX, int chunkZ, int minY, int maxY) {
        WorldHelper.addOreSpawn(state, world, veinPerChunk, size, chunkX, chunkZ, minY, maxY, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public static void addOreSpawn(IBlockState state, World world, int veinPerChunk, int size, int chunkX, int chunkZ, int minY, int maxY, Predicate<IBlockState> predicate) {
        for (int i = 0; i < veinPerChunk; ++i) {
            int diffBtwnMinMaxY = maxY - minY;
            int x = (chunkX << 4) + world.field_73012_v.nextInt(16);
            int y = minY + world.field_73012_v.nextInt(diffBtwnMinMaxY);
            int z = (chunkZ << 4) + world.field_73012_v.nextInt(16);
            new WorldGenMinable(state, size, predicate).func_180709_b(world, world.field_73012_v, new BlockPos(x, y, z));
        }
    }

    public static double getDistance(BlockPos a, BlockPos b) {
        return Math.sqrt(a.func_177951_i((Vec3i)b));
    }

    public static boolean spawnInRange(Entity entity, World world, BlockPos pos, int range) {
        ArrayList lis = Lists.newArrayList();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    lis.add(new BlockPos(x, y, z));
                }
            }
        }
        ArrayList end = Lists.newArrayList();
        for (BlockPos b : lis) {
            if (!WorldHelper.canCreatureTypeSpawnAtLocation(entity, EntityLiving.SpawnPlacementType.ON_GROUND, world, b)) continue;
            end.add(b);
        }
        if (end.isEmpty()) {
            return false;
        }
        Collections.shuffle(end);
        for (BlockPos fin : end) {
            entity.field_70165_t = (double)fin.func_177958_n() + 0.5;
            entity.field_70163_u = (double)fin.func_177956_o() + 0.1;
            entity.field_70161_v = (double)fin.func_177952_p() + 0.5;
            boolean spawned = entity.field_70170_p.func_72838_d(entity);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!spawned) continue;
            return true;
        }
        return false;
    }

    public static boolean canCreatureTypeSpawnAtLocation(Entity entity, EntityLiving.SpawnPlacementType spawnPlacementTypeIn, World worldIn, BlockPos pos) {
        if (!worldIn.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (spawnPlacementTypeIn == EntityLiving.SpawnPlacementType.IN_WATER) {
            return iblockstate.func_185904_a().func_76224_d() && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        }
        BlockPos blockpos = pos.func_177977_b();
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (!state.func_177230_c().canCreatureSpawn(state, (IBlockAccess)worldIn, blockpos, spawnPlacementTypeIn)) {
            return false;
        }
        Block block = worldIn.func_180495_p(blockpos).func_177230_c();
        boolean flag = block != Blocks.field_150357_h && block != Blocks.field_180401_cv;
        boolean upFree = true;
        for (int i = 1; i <= MathHelper.func_76141_d((float)entity.field_70131_O) && upFree; ++i) {
            if (WorldEntitySpawner.func_185331_a((IBlockState)worldIn.func_180495_p(pos.func_177981_b(i)))) continue;
            upFree = false;
        }
        return flag && upFree && WorldEntitySpawner.func_185331_a((IBlockState)iblockstate);
    }

    public static boolean wayFree(World world, BlockPos pos1, BlockPos pos2) {
        return WorldHelper.wayFree(world, (double)pos1.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)pos1.func_177952_p() + 0.5, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
    }

    public static boolean wayFree(World world, double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3d p1 = new Vec3d(x1, y1, z1);
        Vec3d p2 = new Vec3d(x2, y2, z2);
        Vec3d d = new Vec3d(x2 - x1, y2 - y1, z2 - z1);
        d = d.func_72432_b().func_186678_a(0.25);
        HashSet set = Sets.newHashSet();
        while (p1.func_72438_d(p2) > 0.5) {
            set.add(new BlockPos(p1));
            p1 = p1.func_178787_e(d);
        }
        set.remove(new BlockPos(p1));
        set.remove(new BlockPos(p2));
        for (BlockPos p : set) {
            if (world.func_175623_d(p)) continue;
            return false;
        }
        return true;
    }

    public static List<BlockPos> getCuboid(BlockPos center, int rangeX, int rangeY, int rangeZ) {
        ArrayList lis = Lists.newArrayList();
        for (int y = center.func_177956_o() + rangeY; y >= center.func_177956_o() - rangeY; --y) {
            for (int x = center.func_177958_n() - rangeX; x <= center.func_177958_n() + rangeX; ++x) {
                for (int z = center.func_177952_p() - rangeZ; z <= center.func_177952_p() + rangeZ; ++z) {
                    lis.add(new BlockPos(x, y, z));
                }
            }
        }
        return lis;
    }

    public static List<BlockPos> getCuboid(BlockPos center, int range) {
        return WorldHelper.getCuboid(center, range, range, range);
    }

    public static List<BlockPos> getChunk(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        LinkedList lis = Lists.newLinkedList();
        for (int y = world.func_72940_L() - 1; y > 0; --y) {
            for (int x = chunk.field_76635_g * 16; x < chunk.field_76635_g * 16 + 16; ++x) {
                for (int z = chunk.field_76647_h * 16; z < chunk.field_76647_h * 16 + 16; ++z) {
                    lis.add(new BlockPos(x, y, z));
                }
            }
        }
        return lis;
    }

    public static TileEntity getTile(IBlockAccess world, BlockPos pos) {
        return world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
    }

    public static List<BlockPos> getNeighbors(BlockPos p) {
        return Lists.newArrayList((Object[])EnumFacing.field_82609_l).stream().map(f -> p.func_177972_a(f)).collect(Collectors.toList());
    }
}

