/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Sets;
import java.util.Collection;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.network.TeleportMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TeleportationHelper {
    public static void teleportEntity(EntityPlayer player, WorldServer target, BlockPos pos) {
        TeleportationHelper.teleportEntity((Entity)player, target.field_73011_w.getDimension(), pos);
    }

    public static void teleportToPosAndUpdate(Entity e, BlockPos pos) {
        e.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
    }

    public static void teleportToPos(Entity e, BlockPos pos) {
        e.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, e.field_70177_z, e.field_70125_A);
    }

    public static boolean canTeleport(Entity e) {
        return e != null && !e.field_70170_p.field_72995_K && e.func_70089_S() && !e.func_184207_aI() && e.func_184222_aU() && !e.func_184218_aH() && (e instanceof EntityLivingBase || e instanceof EntityItem);
    }

    @Deprecated
    public static void teleportEntity(Entity entity, int dimension, BlockPos pos) {
        EntityPlayerMP player;
        if (!TeleportationHelper.canTeleport(entity)) {
            return;
        }
        int oldDimension = entity.field_70170_p.field_73011_w.getDimension();
        if (oldDimension == dimension) {
            return;
        }
        MinecraftServer server = entity.field_70170_p.func_73046_m();
        WorldServer oldWorld = server.func_71218_a(oldDimension);
        WorldServer newWorld = server.func_71218_a(dimension);
        if (newWorld == null || newWorld.func_73046_m() == null) {
            throw new IllegalArgumentException("Dimension: " + dimension + " doesn't exist!");
        }
        oldWorld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player2 = (EntityPlayerMP)entity;
            player2.func_71053_j();
            player2.func_82242_a(0);
            player2.field_71093_bK = newWorld.field_73011_w.getDimension();
            player2.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player2.field_71093_bK, player2.field_70170_p.func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player2.field_71134_c.func_73081_b()));
            oldWorld.func_184164_w().func_72695_c(player2);
            oldWorld.field_73010_i.remove(player2);
            oldWorld.func_72854_c();
            int i = player2.field_70176_ah;
            int j = player2.field_70164_aj;
            if (player2.field_70175_ag && oldWorld.func_72964_e(i, j).func_150802_k()) {
                oldWorld.func_72964_e(i, j).func_76622_b((Entity)player2);
                oldWorld.func_72964_e(i, j).func_177427_f(true);
            }
            oldWorld.field_72996_f.remove(player2);
            oldWorld.func_72847_b((Entity)player2);
        }
        newWorld.func_72863_F().func_186028_c(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        newWorld.field_72984_F.func_76320_a("placing");
        if (!(entity instanceof EntityPlayer)) {
            NBTTagCompound entityNBT = new NBTTagCompound();
            entity.field_70128_L = false;
            entityNBT.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
            entity.func_189511_e(entityNBT);
            entity.field_70128_L = true;
            entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)newWorld);
            if (entity == null) {
                throw new IllegalArgumentException("Failed to teleport entity to new location");
            }
            entity.field_71093_bK = newWorld.field_73011_w.getDimension();
        }
        boolean flag = entity.field_98038_p;
        entity.field_98038_p = true;
        int entsize = newWorld.field_72996_f.size();
        int plsize = newWorld.field_73010_i.size();
        newWorld.func_72838_d(entity);
        System.out.println("new ent: " + (newWorld.field_72996_f.size() - entsize));
        System.out.println("new pl: " + (newWorld.field_73010_i.size() - plsize));
        entity.field_98038_p = flag;
        entity.func_70029_a((World)newWorld);
        TeleportationHelper.teleportToPosAndUpdate(entity, pos);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.field_71133_b.func_184103_al().func_72375_a(player, newWorld);
            player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        }
        newWorld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.field_71134_c.func_73080_a(newWorld);
            player.field_71133_b.func_184103_al().func_72354_b(player, newWorld);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (PotionEffect potionEffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potionEffect));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldWorld.field_73011_w.getDimension(), newWorld.field_73011_w.getDimension());
        }
        TeleportationHelper.teleportToPosAndUpdate(entity, pos);
        newWorld.field_72984_F.func_76319_b();
        newWorld.func_175650_b((Collection)Sets.newHashSet((Object[])new Entity[]{entity}));
        entity.field_70143_R = 0.0f;
        if (entity instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new TeleportMessage(), (EntityPlayerMP)entity);
        }
    }

    public static boolean serverTeleport(Entity entity, BlockPos pos, int targetDim) {
        if (!TeleportationHelper.canTeleport(entity)) {
            return false;
        }
        EntityPlayerMP player = null;
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int from = entity.field_71093_bK;
        if (from != targetDim) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(targetDim);
            TeleporterEIO teleporter = new TeleporterEIO(toDim);
            if (player != null) {
                server.func_184103_al().transferPlayerToDimension(player, targetDim, (Teleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                }
            } else {
                NBTTagCompound tagCompound = new NBTTagCompound();
                float rotationYaw = entity.field_70177_z;
                float rotationPitch = entity.field_70125_A;
                entity.func_189511_e(tagCompound);
                Class<?> entityClass = entity.getClass();
                fromDim.func_72900_e(entity);
                try {
                    Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                    newEntity.func_70020_e(tagCompound);
                    newEntity.func_70012_b((double)x, (double)y, (double)z, rotationYaw, rotationPitch);
                    newEntity.field_98038_p = true;
                    toDim.func_72838_d(newEntity);
                    newEntity.field_98038_p = false;
                }
                catch (Exception e) {
                    LimeLib.log.error("serverTeleport: Error creating a entity to be created in new dimension.");
                    return false;
                }
            }
        }
        if (!entity.field_70170_p.func_175667_e(pos)) {
            entity.field_70170_p.func_175726_f(pos);
        }
        if (player != null) {
            player.field_71135_a.func_147364_a((double)x + 0.5, (double)y + 1.1, (double)z + 0.5, player.field_70177_z, player.field_70125_A);
        } else {
            entity.func_70634_a((double)x + 0.5, (double)y + 1.1, (double)z + 0.5);
        }
        entity.field_70143_R = 0.0f;
        if (entity instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new TeleportMessage(), (EntityPlayerMP)entity);
        }
        return true;
    }

    public static class TeleporterEIO
    extends Teleporter {
        public TeleporterEIO(WorldServer p_i1963_1_) {
            super(p_i1963_1_);
        }

        public boolean func_85188_a(Entity p_makePortal_1_) {
            return true;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            return true;
        }

        public void func_180266_a(Entity entity, float rotationYaw) {
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
            int z = MathHelper.func_76128_c((double)entity.field_70161_v);
            entity.func_70012_b((double)x, (double)y, (double)z, entity.field_70125_A, entity.field_70177_z);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
        }

        public void func_85189_a(long p_removeStalePortalLocations_1_) {
        }
    }
}

