/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class StackHelper {
    public static boolean equalOreDict(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        for (int i : OreDictionary.getOreIDs((ItemStack)a)) {
            if (!Ints.contains((int[])OreDictionary.getOreIDs((ItemStack)b), (int)i)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalOreDictExact(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        return Sets.newHashSet((Object[])new int[][]{OreDictionary.getOreIDs((ItemStack)a)}).equals(Sets.newHashSet((Object[])new int[][]{OreDictionary.getOreIDs((ItemStack)b)}));
    }

    public static boolean isOre(ItemStack stack) {
        if (stack != null) {
            for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                String oreName = OreDictionary.getOreName((int)i);
                if (!oreName.startsWith("denseore") && (!oreName.startsWith("ore") || !Character.isUpperCase(oreName.charAt(3)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean match(ItemStack stack, Object o) {
        if (stack == null) {
            return false;
        }
        if (o instanceof Item) {
            return stack.func_77973_b() == o;
        }
        if (o instanceof Block) {
            return stack.func_77973_b() == Item.func_150898_a((Block)((Block)o));
        }
        if (o instanceof String) {
            return Ints.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)OreDictionary.getOreID((String)((String)o)));
        }
        if (o instanceof ItemStack) {
            if (((ItemStack)o).func_77952_i() == Short.MAX_VALUE) {
                return stack.func_77973_b() == ((ItemStack)o).func_77973_b();
            }
            return stack.func_77969_a((ItemStack)o);
        }
        return false;
    }

    public static ItemStack stringToStack(String string) {
        Item item = null;
        int amount = 1;
        int meta = 0;
        String[] ar = string.split("[#/]");
        if (ar.length < 1) {
            return null;
        }
        item = Item.func_111206_d((String)ar[0]);
        if (item == null) {
            return null;
        }
        if (ar.length >= 2 && StringUtils.isNumeric((CharSequence)ar[1])) {
            amount = Integer.valueOf(ar[1]);
        }
        if (ar.length >= 3 && StringUtils.isNumeric((CharSequence)ar[2])) {
            meta = Integer.valueOf(ar[2]);
        }
        return new ItemStack(item, amount, meta);
    }

    public static String stackToString(ItemStack stack, boolean simple) {
        if (stack == null) {
            return null;
        }
        String prefix = stack.func_77973_b().getRegistryName().toString();
        if (!simple) {
            return prefix + "#" + stack.field_77994_a + "/" + stack.func_77952_i();
        }
        if (stack.field_77994_a == 1 && stack.func_77952_i() == 0) {
            return prefix;
        }
        if (stack.field_77994_a > 1 && stack.func_77952_i() == 0) {
            return prefix + "#" + stack.field_77994_a;
        }
        return prefix + "#" + stack.field_77994_a + "/" + stack.func_77952_i();
    }

    public static List<ItemStack> split(ItemStack stack) {
        return StackHelper.split(stack, 2);
    }

    public static List<ItemStack> split(ItemStack stack, int splits) {
        if (stack == null) {
            return null;
        }
        List<Integer> ints = Utils.split(stack.field_77994_a, splits);
        ArrayList stacks = Lists.newArrayList();
        for (int i : ints) {
            stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)i));
        }
        return stacks;
    }

    public static ItemStack getStackFromBlock(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            return world.func_180495_p(pos).func_177230_c().getPickBlock(world.func_180495_p(pos), new RayTraceResult(Vec3d.field_186680_a, EnumFacing.UP), world, pos, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
        }
        return world.func_180495_p(pos).func_177230_c().getPickBlock(world.func_180495_p(pos), LimeLib.proxy.getClientRayTrace(), world, pos, player);
    }

    public static boolean isWrench(ItemStack stack) {
        if (stack == null || stack.func_77973_b() instanceof ItemBlock) {
            return false;
        }
        for (String s : new String[]{"wrench", "scrench", "screwdriver"}) {
            boolean flag;
            boolean bl = flag = stack.func_77973_b().getClass().getSimpleName().toLowerCase().contains(s) || stack.func_77977_a().toLowerCase().contains(s) || Arrays.stream(stack.func_77973_b().getClass().getInterfaces()).anyMatch(c -> c.getSimpleName().toLowerCase().contains(s));
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static void addStack(List<ItemStack> lis, ItemStack stack) {
        if (stack == null) {
            return;
        }
        Object[] ar = lis.toArray(new ItemStack[lis.size()]);
        ItemStackHandler inv = new ItemStackHandler((ItemStack[])ar);
        ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
        lis.clear();
        lis.addAll(Lists.newArrayList((Object[])ar));
        if (remain != null) {
            lis.add(remain);
        }
        Iterables.removeIf(lis, s -> s == null);
    }

    public static List<ItemStack> inv2list(IItemHandler inv) {
        ArrayList lis = Lists.newArrayList();
        for (int i = 0; i < inv.getSlots(); ++i) {
            StackHelper.addStack(lis, inv.getStackInSlot(i));
        }
        Iterables.removeIf((Iterable)lis, s -> s == null);
        return lis;
    }

    public static void list2inv(List<ItemStack> lis, IItemHandler inv) {
        for (ItemStack stack : lis) {
            ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
            if (remain == null) continue;
            LimeLib.log.error(remain + " is lost.");
        }
    }

    public static void toStackList(List<Object> lis) {
        for (int i = 0; i < lis.size(); ++i) {
            Object o = lis.get(i);
            if (o instanceof Item) {
                lis.set(i, new ItemStack((Item)o, 1, Short.MAX_VALUE));
            }
            if (!(o instanceof Block)) continue;
            lis.set(i, new ItemStack((Block)o, 1, Short.MAX_VALUE));
        }
    }

    public static void spawnItemStack(World worldIn, BlockPos pos, ItemStack itemStack) {
        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
    }
}

