/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.particle.CommonParticle;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class ParticleHelper {
    public static final ResourceLocation roundParticle = new ResourceLocation("limelib:particle/round_particle");
    public static final ResourceLocation sparkleParticle = new ResourceLocation("limelib:particle/sparkle_particle");
    public static final ResourceLocation squareParticle = new ResourceLocation("limelib:particle/square_particle");

    public static List<Vec3d> getVecsForLine(BlockPos pos1, BlockPos pos2, double frequence) {
        return ParticleHelper.getVecsForLine((double)pos1.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)pos1.func_177952_p() + 0.5, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5, frequence);
    }

    public static List<Vec3d> getVecsForLine(double x1, double y1, double z1, double x2, double y2, double z2, double frequence) {
        ArrayList lis = Lists.newArrayList();
        Vec3d ovec = new Vec3d(x2 - x1, y2 - y1, z2 - z1);
        int amount = (int)(ovec.func_72433_c() * frequence);
        Vec3d toAdd = new Vec3d(ovec.field_72450_a / (double)amount, ovec.field_72448_b / (double)amount, ovec.field_72449_c / (double)amount);
        Vec3d foo = Vec3d.field_186680_a;
        for (int i = 0; i < amount + 1; ++i) {
            lis.add(new Vec3d(x1 + foo.field_72450_a, y1 + foo.field_72448_b, z1 + foo.field_72449_c));
            foo = foo.func_178787_e(toAdd);
        }
        return lis;
    }

    public static List<Vec3d> getVecsForCircle(BlockPos pos1, double radius, double frequence, EnumFacing.Axis axis) {
        return ParticleHelper.getVecsForCircle((double)pos1.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)pos1.func_177952_p() + 0.5, radius, frequence, axis);
    }

    public static List<Vec3d> getVecsForCircle(double x1, double y1, double z1, double radius, double frequence, EnumFacing.Axis axis) {
        ArrayList lis = Lists.newArrayList();
        int amount = (int)(Math.PI * 2 * radius * frequence);
        double degree = 360.0 / (double)amount;
        double add = LimeLib.proxy.getClientWorld().func_82737_E() / (long)((int)radius + 1) % 360L;
        add = 0.0;
        for (double i = 0.0 + add; i < 360.0 + add; i += degree) {
            Vec3d foo = null;
            double value = i * (Math.PI / 180);
            switch (axis) {
                case Y: {
                    foo = new Vec3d(Math.cos(value) * radius, 0.0, Math.sin(value) * radius);
                    break;
                }
                case X: {
                    foo = new Vec3d(0.0, Math.cos(value) * radius, Math.sin(value) * radius);
                    break;
                }
                case Z: {
                    foo = new Vec3d(Math.cos(value) * radius, Math.sin(value) * radius, 0.0);
                }
            }
            lis.add(new Vec3d(x1 + foo.field_72450_a, y1 + foo.field_72448_b, z1 + foo.field_72449_c));
        }
        return lis;
    }

    public static List<Vec3d> getVecsForSquare(double x1, double y1, double z1, double radius, double frequence, EnumFacing.Axis axis) {
        ArrayList lis = Lists.newArrayList();
        switch (axis) {
            case Y: {
                Vec3d a = new Vec3d(x1 + radius, y1, z1 + radius);
                Vec3d b = new Vec3d(x1 - radius, y1, z1 + radius);
                Vec3d c = new Vec3d(x1 - radius, y1, z1 - radius);
                Vec3d d = new Vec3d(x1 + radius, y1, z1 - radius);
                lis.addAll(ParticleHelper.getVecsForLine(a.field_72450_a, a.field_72448_b, a.field_72449_c, b.field_72450_a, b.field_72448_b, b.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(b.field_72450_a, b.field_72448_b, b.field_72449_c, c.field_72450_a, c.field_72448_b, c.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(c.field_72450_a, c.field_72448_b, c.field_72449_c, d.field_72450_a, d.field_72448_b, d.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(d.field_72450_a, d.field_72448_b, d.field_72449_c, a.field_72450_a, a.field_72448_b, a.field_72449_c, frequence));
                break;
            }
            case X: {
                Vec3d a = new Vec3d(x1, y1 + radius, z1 + radius);
                Vec3d b = new Vec3d(x1, y1 - radius, z1 + radius);
                Vec3d c = new Vec3d(x1, y1 - radius, z1 - radius);
                Vec3d d = new Vec3d(x1, y1 + radius, z1 - radius);
                lis.addAll(ParticleHelper.getVecsForLine(a.field_72450_a, a.field_72448_b, a.field_72449_c, b.field_72450_a, b.field_72448_b, b.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(b.field_72450_a, b.field_72448_b, b.field_72449_c, c.field_72450_a, c.field_72448_b, c.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(c.field_72450_a, c.field_72448_b, c.field_72449_c, d.field_72450_a, d.field_72448_b, d.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(d.field_72450_a, d.field_72448_b, d.field_72449_c, a.field_72450_a, a.field_72448_b, a.field_72449_c, frequence));
                break;
            }
            case Z: {
                Vec3d a = new Vec3d(x1 + radius, y1 + radius, z1);
                Vec3d b = new Vec3d(x1 - radius, y1 + radius, z1);
                Vec3d c = new Vec3d(x1 - radius, y1 - radius, z1);
                Vec3d d = new Vec3d(x1 + radius, y1 - radius, z1);
                lis.addAll(ParticleHelper.getVecsForLine(a.field_72450_a, a.field_72448_b, a.field_72449_c, b.field_72450_a, b.field_72448_b, b.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(b.field_72450_a, b.field_72448_b, b.field_72449_c, c.field_72450_a, c.field_72448_b, c.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(c.field_72450_a, c.field_72448_b, c.field_72449_c, d.field_72450_a, d.field_72448_b, d.field_72449_c, frequence));
                lis.addAll(ParticleHelper.getVecsForLine(d.field_72450_a, d.field_72448_b, d.field_72449_c, a.field_72450_a, a.field_72448_b, a.field_72449_c, frequence));
                break;
            }
        }
        return lis;
    }

    public static List<Vec3d> getVecsForExplosion(double force, double frequence, EnumFacing.Axis axis) {
        ArrayList lis = Lists.newArrayList();
        for (Vec3d vec : ParticleHelper.getVecsForCircle(0.0, 0.0, 0.0, force, frequence, axis)) {
            lis.add(new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
        }
        return lis;
    }

    public static Vec3d getVecForSpirale(double force, double speed, double frequence, boolean reverse, EnumFacing.Axis axis) {
        List lis = ParticleHelper.getVecsForCircle(0.0, 0.0, 0.0, force, frequence, axis);
        if (reverse) {
            lis = Lists.reverse(lis);
        }
        int index = (int)((double)(System.currentTimeMillis() % Integer.MAX_VALUE) * speed) % lis.size();
        Vec3d vec = (Vec3d)lis.get(index);
        switch (axis) {
            case Y: {
                return new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c);
            }
            case X: {
                return new Vec3d(0.0, vec.field_72448_b, vec.field_72449_c);
            }
            case Z: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, 0.0);
            }
        }
        return null;
    }

    public static List<Vec3d> getVecsForBlock(BlockPos pos, int amount) {
        ArrayList lis = Lists.newArrayList();
        Random random = new Random();
        for (int i = 0; i < amount; ++i) {
            lis.add(new Vec3d((double)pos.func_177958_n() + MathHelper.func_82716_a((Random)random, (double)0.0, (double)1.0), (double)pos.func_177956_o() + MathHelper.func_82716_a((Random)random, (double)0.0, (double)1.0), (double)pos.func_177952_p() + MathHelper.func_82716_a((Random)random, (double)0.0, (double)1.0)));
        }
        return lis;
    }

    public static void renderParticle(CommonParticle par) {
        LimeLib.proxy.renderParticle(par);
    }
}

