/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mrriegel.limelib.LimeLib;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;

public class NBTHelper {
    private static final String SIZE = "\u00a7Size";

    public static boolean hasTag(NBTTagCompound nbt, String keyName) {
        return nbt != null && nbt.func_74764_b(keyName);
    }

    public static void removeTag(NBTTagCompound nbt, String keyName) {
        if (nbt == null) {
            return;
        }
        nbt.func_82580_o(keyName);
    }

    public static NBTTagList createList(NBTBase ... list) {
        return NBTHelper.createList(Lists.newArrayList((Object[])list));
    }

    public static NBTTagList createList(List<NBTBase> list) {
        NBTTagList tagList = new NBTTagList();
        for (NBTBase b : list) {
            tagList.func_74742_a(b);
        }
        return tagList;
    }

    public static NBTTagCompound getTag(Object ... os) {
        NBTTagCompound nbt = new NBTTagCompound();
        List<NBTBase> lis = NBTHelper.getNBTs(os);
        NBTHelper.setInt(nbt, "size", lis.size());
        for (int i = 0; i < lis.size(); ++i) {
            NBTBase o = lis.get(i);
            nbt.func_74782_a("" + i, o);
        }
        return nbt;
    }

    public static List<NBTBase> getObjects(NBTTagCompound nbt) {
        ArrayList lis = Lists.newArrayList();
        for (int i = 0; i < NBTHelper.getInt(nbt, "size"); ++i) {
            lis.add(nbt.func_74781_a("" + i));
        }
        return lis;
    }

    public static List<NBTBase> getNBTs(Object ... os) {
        ArrayList lis = Lists.newArrayList();
        for (Object o : os) {
            try {
                if (o.getClass().equals(Boolean.class)) {
                    lis.add(new NBTTagByte((Boolean)o != false ? (byte)1 : 0));
                    continue;
                }
                if (o.getClass().equals(Byte.class)) {
                    lis.add(new NBTTagByte(((Byte)o).byteValue()));
                    continue;
                }
                if (o.getClass().equals(Short.class)) {
                    lis.add(new NBTTagShort(((Short)o).shortValue()));
                    continue;
                }
                if (o.getClass().equals(Integer.class)) {
                    lis.add(new NBTTagInt(((Integer)o).intValue()));
                    continue;
                }
                if (o.getClass().equals(Long.class)) {
                    lis.add(new NBTTagLong(((Long)o).longValue()));
                    continue;
                }
                if (o.getClass().equals(Float.class)) {
                    lis.add(new NBTTagFloat(((Float)o).floatValue()));
                    continue;
                }
                if (o.getClass().equals(Double.class)) {
                    lis.add(new NBTTagDouble(((Double)o).doubleValue()));
                    continue;
                }
                if (o.getClass().equals(String.class)) {
                    lis.add(new NBTTagString((String)o));
                    continue;
                }
                if (o.getClass().equals(BlockPos.class)) {
                    lis.add(new NBTTagLong(((BlockPos)o).func_177986_g()));
                    continue;
                }
                if (o.getClass().equals(ItemStack.class)) {
                    NBTTagCompound n1 = new NBTTagCompound();
                    ((ItemStack)o).func_77955_b(n1);
                    lis.add(n1);
                    continue;
                }
                LimeLib.log.warn("Unacceptable Class.");
            }
            catch (Exception e) {
                LimeLib.log.error("Couldn't construct NBTBase.");
            }
        }
        return lis;
    }

    public static <T> T getObjectFrom(NBTBase nbt, Class<T> clazz) {
        try {
            if (clazz.equals(Boolean.class)) {
                return (T)(((NBTTagByte)nbt).func_150290_f() == 1 ? Boolean.TRUE : Boolean.FALSE);
            }
            if (clazz.equals(Byte.class)) {
                return (T)new Byte(((NBTTagByte)nbt).func_150290_f());
            }
            if (clazz.equals(Short.class)) {
                return (T)new Short(((NBTTagShort)nbt).func_150289_e());
            }
            if (clazz.equals(Integer.class)) {
                return (T)new Integer(((NBTTagInt)nbt).func_150287_d());
            }
            if (clazz.equals(Long.class)) {
                return (T)new Long(((NBTTagLong)nbt).func_150291_c());
            }
            if (clazz.equals(Float.class)) {
                return (T)new Float(((NBTTagFloat)nbt).func_150288_h());
            }
            if (clazz.equals(Double.class)) {
                return (T)new Double(((NBTTagDouble)nbt).func_150286_g());
            }
            if (clazz.equals(String.class)) {
                return (T)new String(((NBTTagString)nbt).func_150285_a_());
            }
            if (clazz.equals(BlockPos.class)) {
                return (T)BlockPos.func_177969_a((long)((NBTTagLong)nbt).func_150291_c());
            }
            if (clazz.equals(ItemStack.class)) {
                return (T)ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt));
            }
            LimeLib.log.warn("Unacceptable Class.");
        }
        catch (ClassCastException e) {
            LimeLib.log.error("Wrong Class. Obtained: " + clazz.toString());
        }
        return null;
    }

    public static Object getObjectFrom(NBTBase nbt) {
        if (nbt instanceof NBTTagByte) {
            return new Byte(((NBTTagByte)nbt).func_150290_f());
        }
        if (nbt instanceof NBTTagShort) {
            return new Short(((NBTTagShort)nbt).func_150289_e());
        }
        if (nbt instanceof NBTTagInt) {
            return new Integer(((NBTTagInt)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagLong) {
            return new Long(((NBTTagLong)nbt).func_150291_c());
        }
        if (nbt instanceof NBTTagFloat) {
            return new Float(((NBTTagFloat)nbt).func_150288_h());
        }
        if (nbt instanceof NBTTagDouble) {
            return new Double(((NBTTagDouble)nbt).func_150286_g());
        }
        if (nbt instanceof NBTTagString) {
            return new String(((NBTTagString)nbt).func_150285_a_());
        }
        LimeLib.log.warn("Unacceptable Class.");
        return null;
    }

    public static NBTTagList getList(NBTTagCompound nbt, String tag, int objtype, boolean nullifyOnFail) {
        return nbt != null && NBTHelper.hasTag(nbt, tag) ? nbt.func_150295_c(tag, objtype) : (nullifyOnFail ? null : new NBTTagList());
    }

    public static NBTTagCompound setList(NBTTagCompound nbt, String tag, NBTTagList list) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74782_a(tag, (NBTBase)list);
        return nbt;
    }

    public static String getString(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 8)) {
            return null;
        }
        return nbt.func_74779_i(keyName);
    }

    public static NBTTagCompound setString(NBTTagCompound nbt, String keyName, String keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null) {
            nbt.func_74778_a(keyName, keyValue);
        }
        return nbt;
    }

    public static boolean getBoolean(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return false;
        }
        return nbt.func_74767_n(keyName);
    }

    public static NBTTagCompound setBoolean(NBTTagCompound nbt, String keyName, boolean keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74757_a(keyName, keyValue);
        return nbt;
    }

    public static byte getByte(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return 0;
        }
        return nbt.func_74771_c(keyName);
    }

    public static NBTTagCompound setByte(NBTTagCompound nbt, String keyName, byte keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74774_a(keyName, keyValue);
        return nbt;
    }

    public static short getShort(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return 0;
        }
        return nbt.func_74765_d(keyName);
    }

    public static NBTTagCompound setShort(NBTTagCompound nbt, String keyName, short keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74777_a(keyName, keyValue);
        return nbt;
    }

    public static int getInt(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return 0;
        }
        return nbt.func_74762_e(keyName);
    }

    public static NBTTagCompound setInt(NBTTagCompound nbt, String keyName, int keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74768_a(keyName, keyValue);
        return nbt;
    }

    public static long getLong(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return 0L;
        }
        return nbt.func_74763_f(keyName);
    }

    public static NBTTagCompound setLong(NBTTagCompound nbt, String keyName, long keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74772_a(keyName, keyValue);
        return nbt;
    }

    public static float getFloat(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return 0.0f;
        }
        return nbt.func_74760_g(keyName);
    }

    public static NBTTagCompound setFloat(NBTTagCompound nbt, String keyName, float keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74776_a(keyName, keyValue);
        return nbt;
    }

    public static double getDouble(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_150297_b(keyName, 99)) {
            return 0.0;
        }
        return nbt.func_74769_h(keyName);
    }

    public static NBTTagCompound setDouble(NBTTagCompound nbt, String keyName, double keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74780_a(keyName, keyValue);
        return nbt;
    }

    public static NBTTagCompound getTag(NBTTagCompound nbt, String keyName) {
        if (nbt == null) {
            return null;
        }
        return (NBTTagCompound)nbt.func_74781_a(keyName);
    }

    public static NBTTagCompound setTag(NBTTagCompound nbt, String keyName, NBTTagCompound keyValue) {
        if (nbt == null) {
            return nbt;
        }
        nbt.func_74782_a(keyName, (NBTBase)keyValue);
        return nbt;
    }

    public static ItemStack getItemStack(NBTTagCompound nbt, String keyName) {
        if (nbt == null || !nbt.func_74764_b(keyName)) {
            return null;
        }
        NBTTagCompound res = (NBTTagCompound)nbt.func_74781_a(keyName);
        return ItemStack.func_77949_a((NBTTagCompound)res);
    }

    public static NBTTagCompound setItemStack(NBTTagCompound nbt, String keyName, ItemStack keyValue) {
        if (nbt == null) {
            return nbt;
        }
        NBTTagCompound res = new NBTTagCompound();
        if (keyValue != null) {
            keyValue.func_77955_b(res);
        }
        nbt.func_74782_a(keyName, (NBTBase)res);
        return nbt;
    }

    public static <E extends Enum<E>> E getEnum(NBTTagCompound nbt, String keyName, Class<E> clazz) {
        if (nbt == null || !nbt.func_74764_b(keyName)) {
            return null;
        }
        String s = NBTHelper.getString(nbt, keyName);
        for (Enum e : EnumSet.allOf(clazz)) {
            if (!e.name().equals(s)) continue;
            return (E)e;
        }
        return null;
    }

    public static <E extends Enum<E>> NBTTagCompound setEnum(NBTTagCompound nbt, String keyName, E keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null) {
            NBTHelper.setString(nbt, keyName, keyValue.name());
        }
        return nbt;
    }

    public static List<String> getStringList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getString(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getString(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setStringList(NBTTagCompound nbt, String keyName, List<String> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                String s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setString(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<Boolean> getBooleanList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getBoolean(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getBoolean(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setBooleanList(NBTTagCompound nbt, String keyName, List<Boolean> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Boolean s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setBoolean(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<Byte> getByteList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getByte(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getByte(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setByteList(NBTTagCompound nbt, String keyName, List<Byte> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Byte s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setByte(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<Short> getShortList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getShort(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getShort(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setShortList(NBTTagCompound nbt, String keyName, List<Short> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Short s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setShort(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<Integer> getIntList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getInt(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getInt(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setIntList(NBTTagCompound nbt, String keyName, List<Integer> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Integer s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setInt(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<Long> getLongList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getLong(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getLong(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setLongList(NBTTagCompound nbt, String keyName, List<Long> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Long s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setLong(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<Float> getFloatList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(Float.valueOf(NBTHelper.getFloat(nbt, keyName + ":" + i)));
                continue;
            }
            lis.add(Float.valueOf(NBTHelper.getFloat(nbt, keyName + "-" + i)));
        }
        return lis;
    }

    public static NBTTagCompound setFloatList(NBTTagCompound nbt, String keyName, List<Float> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Float s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setFloat(nbt, keyName + "-" + i, s.floatValue());
            }
        }
        return nbt;
    }

    public static List<Double> getDoubleList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getDouble(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getDouble(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setDoubleList(NBTTagCompound nbt, String keyName, List<Double> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Double s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setDouble(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<NBTTagCompound> getTagList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getTag(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getTag(nbt, keyName + "-" + i));
        }
        return lis;
    }

    public static NBTTagCompound setTagList(NBTTagCompound nbt, String keyName, List<NBTTagCompound> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                NBTTagCompound s = keyValue.get(i);
                NBTHelper.setTag(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }

    public static List<ItemStack> getItemStackList(NBTTagCompound nbt, String keyName) {
        ArrayList lis = Lists.newArrayList();
        int size = NBTHelper.getInt(nbt, keyName + SIZE);
        for (int i = 0; i < size; ++i) {
            if (NBTHelper.hasTag(nbt, keyName + ":" + i)) {
                lis.add(NBTHelper.getItemStack(nbt, keyName + ":" + i));
                continue;
            }
            lis.add(NBTHelper.getItemStack(nbt, keyName + ":" + i));
        }
        return lis;
    }

    public static NBTTagCompound setItemStackList(NBTTagCompound nbt, String keyName, List<ItemStack> keyValue) {
        if (nbt == null) {
            return nbt;
        }
        if (keyValue != null && !keyValue.isEmpty()) {
            NBTHelper.setInt(nbt, keyName + SIZE, keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                ItemStack s = keyValue.get(i);
                NBTHelper.setItemStack(nbt, keyName + "-" + i, s);
            }
        }
        return nbt;
    }
}

