/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import java.util.List;
import java.util.function.Predicate;
import mrriegel.limelib.helper.StackHelper;
import mrriegel.limelib.helper.WorldHelper;
import mrriegel.limelib.util.FilterItem;
import mrriegel.limelib.util.StackWrapper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InvHelper {
    public static boolean hasItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || tile instanceof IInventory;
    }

    public static boolean hasItemHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.hasItemHandler(WorldHelper.getTile(world, pos), side);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static IItemHandler getItemHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.getItemHandler(WorldHelper.getTile(world, pos), side);
    }

    public static ItemStack insert(TileEntity tile, ItemStack stack, EnumFacing side) {
        if (tile == null) {
            return stack;
        }
        IItemHandler inv = InvHelper.getItemHandler(tile, side);
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
    }

    public static int canInsert(IItemHandler inv, ItemStack stack) {
        if (inv == null || stack == null) {
            return 0;
        }
        ItemStack s = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true);
        int rest = s.field_77994_a;
        return stack.field_77994_a - rest;
    }

    public static boolean contains(IItemHandler inv, ItemStack stack) {
        if (inv == null || stack == null) {
            return false;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public static int getAmount(IItemHandler inv, FilterItem fil) {
        if (inv == null || fil == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot)) continue;
            amount += slot.field_77994_a;
        }
        return amount;
    }

    public static ItemStack extractItem(IItemHandler inv, FilterItem fil, int num, boolean simulate) {
        if (fil == null) {
            return null;
        }
        return InvHelper.extractItem(inv, (ItemStack s) -> fil.match((ItemStack)s), num, simulate);
    }

    public static ItemStack extractItem(IItemHandler inv, Predicate<ItemStack> pred, int num, boolean simulate) {
        if (inv == null || pred == null) {
            return null;
        }
        ItemStack extracted = null;
        int missing = num;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!pred.test(slot) || (ex = inv.extractItem(i, missing, simulate)) == null) continue;
            if (extracted == null) {
                extracted = ex.func_77946_l();
            } else {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)extracted, (ItemStack)ex)) continue;
                extracted.field_77994_a += ex.field_77994_a;
            }
            if ((missing -= ex.field_77994_a) != 0) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)ex, (int)num);
        }
        return extracted;
    }

    public static void sort(IItemHandler inv) {
        List<ItemStack> ex = StackHelper.inv2list(inv);
        List<StackWrapper> wraps = StackWrapper.toWrapperList(ex);
        List<ItemStack> lis = StackWrapper.toStackList(wraps);
        InvHelper.clear(inv);
        StackHelper.list2inv(lis, inv);
    }

    public static void clear(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            if (inv instanceof IItemHandlerModifiable) {
                ((IItemHandlerModifiable)inv).setStackInSlot(i, null);
                continue;
            }
            inv.extractItem(i, inv.getStackInSlot((int)i).field_77994_a, false);
        }
    }

    public static boolean hasFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.getFluidHandler(world, pos, side) != null;
    }

    public static boolean hasFluidHandler(TileEntity tile, EnumFacing facing) {
        return InvHelper.getFluidHandler(tile, facing) != null;
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        }
        return null;
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.getFluidHandler(WorldHelper.getTile(world, pos), side);
    }

    public static boolean contains(IFluidHandler inv, FluidStack stack) {
        if (inv == null || stack == null) {
            return false;
        }
        for (IFluidTankProperties p : inv.getTankProperties()) {
            if (!stack.isFluidEqual(p.getContents())) continue;
            return true;
        }
        return false;
    }

    public static int getAmount(IFluidHandler inv, FluidStack stack) {
        if (inv == null || stack == null) {
            return 0;
        }
        int amount = 0;
        for (IFluidTankProperties p : inv.getTankProperties()) {
            if (!stack.isFluidEqual(p.getContents())) continue;
            amount += p.getContents().amount;
        }
        return amount;
    }

    public static void clear(IFluidHandler inv) {
        if (inv == null) {
            return;
        }
        for (IFluidTankProperties p : inv.getTankProperties()) {
            p.canDrain();
            inv.drain(Integer.MAX_VALUE, true);
        }
    }
}

