/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import mrriegel.limelib.LimeLib;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

public class EnergyHelper {
    public static Energy isEnergyContainer(ICapabilityProvider container, EnumFacing side, Energy ... energys) {
        if (container == null) {
            return null;
        }
        HashSet set = Sets.newHashSet((Object[])energys);
        if (set.contains((Object)Energy.FORGE) && container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return Energy.FORGE;
        }
        if (set.contains((Object)Energy.TESLA) && LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)) {
            return Energy.TESLA;
        }
        if (set.contains((Object)Energy.RF) && container instanceof TileEntity && container instanceof IEnergyHandler) {
            return Energy.RF;
        }
        if (set.contains((Object)Energy.RF) && container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return Energy.RF;
        }
        return null;
    }

    public static Energy isEnergyContainer(ICapabilityProvider container, EnumFacing side) {
        return EnergyHelper.isEnergyContainer(container, side, Energy.values());
    }

    public static long getEnergy(ICapabilityProvider container, EnumFacing side) {
        if (container == null) {
            return 0L;
        }
        if (container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).getEnergyStored();
        }
        if (LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)) {
            return ((ITeslaHolder)container.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)).getStoredPower();
        }
        if (container instanceof TileEntity && container instanceof IEnergyHandler) {
            return ((IEnergyHandler)container).getEnergyStored(side);
        }
        if (container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).getEnergyStored((ItemStack)container);
        }
        return 0L;
    }

    public static long getMaxEnergy(ICapabilityProvider container, EnumFacing side) {
        if (container == null) {
            return 0L;
        }
        if (container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).getMaxEnergyStored();
        }
        if (LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)) {
            return ((ITeslaHolder)container.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)).getCapacity();
        }
        if (container instanceof TileEntity && container instanceof IEnergyHandler) {
            return ((IEnergyHandler)container).getMaxEnergyStored(side);
        }
        if (container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).getMaxEnergyStored((ItemStack)container);
        }
        return 0L;
    }

    public static long receiveEnergy(ICapabilityProvider container, EnumFacing side, int maxReceive, boolean simulate) {
        if (container == null) {
            return 0L;
        }
        if (container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).receiveEnergy(maxReceive, simulate);
        }
        if (LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side)) {
            return ((ITeslaConsumer)container.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side)).givePower((long)maxReceive, simulate);
        }
        if (container instanceof TileEntity && container instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)container).receiveEnergy(side, maxReceive, simulate);
        }
        if (container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).receiveEnergy((ItemStack)container, maxReceive, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(ICapabilityProvider container, EnumFacing side, int maxExtract, boolean simulate) {
        if (container == null) {
            return 0L;
        }
        if (container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).extractEnergy(maxExtract, simulate);
        }
        if (LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side)) {
            return ((ITeslaProducer)container.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side)).takePower((long)maxExtract, simulate);
        }
        if (container instanceof TileEntity && container instanceof IEnergyProvider) {
            return ((IEnergyProvider)container).extractEnergy(side, maxExtract, simulate);
        }
        if (container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).extractEnergy((ItemStack)container, maxExtract, simulate);
        }
        return 0L;
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
    public static class ItemEnergyWrapper
    implements IEnergyStorage,
    ITeslaHolder,
    ITeslaConsumer,
    ITeslaProducer {
        ItemStack stack;

        public ItemEnergyWrapper(ItemStack stack) {
            this.stack = stack;
            Preconditions.checkArgument((boolean)(stack.func_77973_b() instanceof IEnergyContainerItem));
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ((IEnergyContainerItem)this.stack.func_77973_b()).receiveEnergy(this.stack, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return ((IEnergyContainerItem)this.stack.func_77973_b()).extractEnergy(this.stack, maxExtract, simulate);
        }

        public int getEnergyStored() {
            return ((IEnergyContainerItem)this.stack.func_77973_b()).getEnergyStored(this.stack);
        }

        public int getMaxEnergyStored() {
            return ((IEnergyContainerItem)this.stack.func_77973_b()).getMaxEnergyStored(this.stack);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        public long takePower(long power, boolean simulated) {
            return this.extractEnergy((int)(power % Integer.MAX_VALUE), simulated);
        }

        public long givePower(long power, boolean simulated) {
            return this.receiveEnergy((int)(power % Integer.MAX_VALUE), simulated);
        }

        public long getStoredPower() {
            return this.getEnergyStored();
        }

        public long getCapacity() {
            return this.getMaxEnergyStored();
        }
    }

    public static enum Energy {
        RF("RF"),
        FORGE("FU"),
        TESLA("Tesla");

        public String unit;

        private Energy(String unit) {
            this.unit = unit;
        }
    }
}

