/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.helper.StackHelper;
import mrriegel.limelib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockHelper {
    private static Map<Class<? extends Block>, Method> methodMap = Maps.newHashMap();

    public static boolean isBlockBreakable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return !world.func_175623_d(pos) && !state.func_177230_c().func_149688_o(state).func_76224_d() && state.func_177230_c().func_176195_g(state, world, pos) > -1.0f;
    }

    public static List<ItemStack> breakBlock(World world, BlockPos pos, IBlockState state, @Nullable EntityPlayer player, boolean silk, int fortune, boolean dropXP, boolean particle) {
        if (!BlockHelper.isBlockBreakable(world, pos)) {
            return Lists.newArrayList();
        }
        int exp = state.func_177230_c().getExpDrop(state, (IBlockAccess)world, pos, fortune);
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            event.setExpToDrop(exp);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return Lists.newArrayList();
            }
            exp = event.getExpToDrop();
        }
        if (particle) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
        ArrayList lis = null;
        if (silk && state.func_177230_c().canSilkHarvest(world, pos, state, player)) {
            lis = Lists.newArrayList();
            ItemStack drop = BlockHelper.getSilkDrop(world, pos, player);
            if (drop != null) {
                lis.add(drop);
            }
        } else {
            lis = BlockHelper.getFortuneDrops(world, pos, player, fortune);
        }
        if (player != null && !ForgeHooks.canHarvestBlock((Block)state.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            lis.clear();
        }
        world.func_175698_g(pos);
        if (dropXP && !silk && exp > 0) {
            state.func_177230_c().func_180637_b(world, pos, exp);
        }
        return lis;
    }

    public static List<ItemStack> getFortuneDrops(World world, BlockPos pos, EntityPlayer player, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList tmp = Lists.newArrayList();
        tmp.addAll(Lists.newArrayList((Iterable)state.func_177230_c().getDrops((IBlockAccess)world, pos, state, fortune)));
        float chance = ForgeEventFactory.fireBlockHarvesting((List)tmp, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        ArrayList lis = Lists.newArrayList();
        for (ItemStack item : tmp) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            lis.add(item);
        }
        Iterator it = lis.iterator();
        while (it.hasNext()) {
            ItemStack s = (ItemStack)it.next();
            if (s != null) continue;
            it.remove();
        }
        return lis;
    }

    public static ItemStack getSilkDrop(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList tmp = Lists.newArrayList();
        if (state.func_177230_c().canSilkHarvest(world, pos, state, player)) {
            Method m = null;
            Class<?> clazz = state.func_177230_c().getClass();
            HashSet clazzes = Sets.newHashSet((Object[])new Class[]{clazz});
            while (m == null) {
                if (methodMap.containsKey(clazz)) {
                    m = methodMap.get(clazz);
                    continue;
                }
                try {
                    m = ReflectionHelper.findMethod(clazz, (Object)state.func_177230_c(), (String[])new String[]{"func_180643_i", "getSilkTouchDrop"}, (Class[])new Class[]{IBlockState.class});
                }
                catch (Exception e) {
                    clazz = clazz.getSuperclass();
                    if (clazz == null) break;
                    clazzes.add(clazz);
                }
            }
            for (Class c : clazzes) {
                methodMap.put(c, m);
            }
            ItemStack silked = null;
            try {
                silked = (ItemStack)m.invoke((Object)state.func_177230_c(), state);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
            if (silked != null) {
                tmp.add(silked);
            }
        }
        ForgeEventFactory.fireBlockHarvesting((List)tmp, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        return tmp.isEmpty() ? null : (ItemStack)tmp.get(0);
    }

    public static boolean isOre(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().func_149686_d(state)) {
            return false;
        }
        try {
            ItemStack stack = null;
            try {
                stack = BlockHelper.getSilkDrop(world, pos, (EntityPlayer)(world.field_72995_K ? LimeLib.proxy.getClientPlayer() : Utils.getFakePlayer((WorldServer)world)));
                if (stack == null) {
                    stack = state.func_177230_c().getPickBlock(state, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.UP), world, pos, null);
                }
                return StackHelper.isOre(stack);
            }
            catch (Exception e) {
                stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
                return StackHelper.isOre(stack);
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isToolEffective(ItemStack tool, World world, BlockPos pos, boolean reallyEffective) {
        if (ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)tool)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos)).func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        return !reallyEffective && state.func_177230_c().getHarvestTool(state) == null || tool.func_77973_b().getToolClasses(tool).contains(state.func_177230_c().getHarvestTool(state));
    }

    public static boolean canToolHarvestBlock(IBlockAccess world, BlockPos pos, @Nonnull ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        state = state.func_177230_c().func_176221_a(state, world, pos);
        if (world instanceof World && state.func_185887_b((World)world, pos) < 0.0f) {
            return false;
        }
        String tool = state.func_177230_c().getHarvestTool(state);
        if (state.func_177230_c().func_149688_o(state).func_76229_l()) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b().getHarvestLevel(stack, tool, null, null) >= state.func_177230_c().getHarvestLevel(state);
    }
}

