/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.gui.component.GuiComponent;
import mrriegel.limelib.gui.element.ITooltip;

public class MCPanel
extends GuiComponent {
    protected List<GuiComponent> children = Lists.newArrayList();

    public MCPanel(int x, int y, int width, int height, GuiDrawer drawer) {
        super(x, y, width, height, drawer);
        this.init();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        for (GuiComponent e : this.children) {
            if (!e.isVisible()) continue;
            e.drawForeground(mouseX, mouseY);
            if (!(e instanceof ITooltip) || !e.isMouseOver(mouseX, mouseY)) continue;
            ((ITooltip)((Object)e)).drawTooltip(mouseX - this.drawer.guiLeft, mouseY - this.drawer.guiTop);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        this.drawer.drawFramedRectangle(this.x + this.getOffsetX(), this.y + this.getOffsetY(), this.width, this.height);
        for (GuiComponent e : this.children) {
            if (!e.isVisible()) continue;
            e.drawBackground(mouseX, mouseY);
        }
    }

    @Override
    public void onUpdate() {
        for (GuiComponent e : this.children) {
            e.onUpdate();
        }
    }

    public List<GuiComponent> getElements() {
        return ImmutableList.copyOf(this.children);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void add(GuiComponent element) {
        if (element == this) {
            throw new IllegalArgumentException("adding panel's parent to itself");
        }
        element.parent = this;
        this.children.add(element);
        if (!(element instanceof MCPanel)) {
            element.init();
        }
    }
}

