/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui.component;

import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.gui.component.MCPanel;
import net.minecraft.client.Minecraft;

public abstract class GuiComponent {
    protected GuiDrawer drawer;
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean visible;
    protected MCPanel parent;
    protected Minecraft mc;

    public GuiComponent(int x, int y, int width, int height, GuiDrawer drawer) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.drawer = drawer;
        this.visible = true;
        this.mc = Minecraft.func_71410_x();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected int getOffsetX() {
        int foo = 0;
        MCPanel pan = this.parent;
        while (pan != null) {
            foo += pan.x;
            pan = pan.parent;
        }
        return foo;
    }

    protected int getOffsetY() {
        int foo = 0;
        MCPanel pan = this.parent;
        while (pan != null) {
            foo += pan.y;
            pan = pan.parent;
        }
        return foo;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int x = this.x + this.drawer.guiLeft + this.getOffsetX();
        int y = this.y + this.drawer.guiTop + this.getOffsetY();
        return mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
    }

    public abstract void drawForeground(int var1, int var2);

    public abstract void drawBackground(int var1, int var2);

    public void init() {
    }

    public void onUpdate() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.visible ? 1231 : 1237);
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuiComponent other = (GuiComponent)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return "GuiElement [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", visible=" + this.visible + "]";
    }
}

