/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mrriegel.limelib.gui.slot.SlotFilter;
import mrriegel.limelib.gui.slot.SlotGhost;
import mrriegel.limelib.gui.slot.SlotOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommonContainer
extends Container {
    protected InventoryPlayer invPlayer;
    protected Map<String, IInventory> invs;

    public CommonContainer(InventoryPlayer invPlayer, Pair<String, IInventory> ... invs) {
        this.invPlayer = invPlayer;
        this.invs = Maps.newHashMap();
        if (invs != null) {
            for (Pair<String, IInventory> e : invs) {
                if (e == null) continue;
                this.invs.put((String)e.getLeft(), (IInventory)e.getRight());
            }
        }
        this.modifyInvs();
        this.initSlots();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public EntityPlayer getPlayer() {
        return this.invPlayer.field_70458_d;
    }

    protected abstract void initSlots();

    protected void modifyInvs() {
    }

    protected abstract List<Area> allowedSlots(ItemStack var1, IInventory var2, int var3);

    protected Area getAreaForEntireInv(IInventory inv) {
        return this.getAreaForInv(inv, 0, inv.func_70302_i_());
    }

    protected Area getAreaForInv(IInventory inv, int start, int total) {
        ArrayList l = Lists.newArrayList();
        for (Slot s : this.field_75151_b) {
            if (s.field_75224_c != inv || s.getSlotIndex() < start || s.getSlotIndex() >= total + start) continue;
            l.add(s.getSlotIndex());
        }
        if (l.isEmpty()) {
            return null;
        }
        Collections.sort(l);
        return new Area(inv, (Integer)l.get(0), (Integer)l.get(l.size() - 1));
    }

    protected List<Slot> getSlotsFor(IInventory inv) {
        ArrayList slots = Lists.newArrayList();
        for (Slot s : this.field_75151_b) {
            if (s.field_75224_c != inv) continue;
            slots.add(s);
        }
        return slots;
    }

    protected void initPlayerSlots(int x, int y) {
        this.initSlots((IInventory)this.invPlayer, x, y + 58, 9, 1, 0);
        this.initSlots((IInventory)this.invPlayer, x, y, 9, 3, 9);
    }

    protected void initSlots(IInventory inv, int x, int y, int width, int height, int startIndex, Class<? extends Slot> clazz, Object ... args) {
        if (inv == null) {
            return;
        }
        for (int k = 0; k < height; ++k) {
            int id;
            for (int i = 0; i < width && (id = i + k * width + startIndex) < inv.func_70302_i_(); ++i) {
                Slot slot = null;
                if (clazz == Slot.class) {
                    slot = new Slot(inv, id, x + i * 18, y + k * 18){

                        public void func_75218_e() {
                            super.func_75218_e();
                            CommonContainer.this.inventoryChanged();
                        }
                    };
                } else if (clazz == SlotGhost.class) {
                    slot = new SlotGhost(inv, id, x + i * 18, y + k * 18){

                        public void func_75218_e() {
                            super.func_75218_e();
                            CommonContainer.this.inventoryChanged();
                        }
                    };
                } else if (clazz == SlotOutput.class) {
                    slot = new SlotOutput(inv, id, x + i * 18, y + k * 18){

                        public void func_75218_e() {
                            super.func_75218_e();
                            CommonContainer.this.inventoryChanged();
                        }
                    };
                } else if (clazz == SlotFilter.class && args != null && args[0] instanceof Predicate) {
                    slot = new SlotFilter(inv, id, x + i * 18, y + k * 18, (Predicate)args[0]){

                        public void func_75218_e() {
                            super.func_75218_e();
                            CommonContainer.this.inventoryChanged();
                        }
                    };
                }
                if (slot == null) continue;
                this.func_75146_a(slot);
            }
        }
    }

    protected void initSlots(IInventory inv, int x, int y, int width, int height, int startIndex) {
        this.initSlots(inv, x, y, width, height, startIndex, Slot.class, new Object[0]);
    }

    protected void initSlots(IInventory inv, int x, int y, int width, int height) {
        this.initSlots(inv, x, y, width, height, 0);
    }

    protected void initSlots(String name, int x, int y, int width, int height, int startIndex) {
        this.initSlots(this.invs.get(name), x, y, width, height, startIndex);
    }

    protected void initSlots(String name, int x, int y, int width, int height) {
        this.initSlots(name, x, y, width, height, 0);
    }

    protected void inventoryChanged() {
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (playerIn.field_70170_p.field_72995_K) {
            return null;
        }
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            List<Area> ar = this.allowedSlots(itemstack1, slot.field_75224_c, slot.getSlotIndex());
            if (ar == null) {
                return null;
            }
            ar.removeAll(Collections.singleton(null));
            boolean merged = false;
            for (Area p : ar) {
                Slot minSlot = this.func_75147_a(p.inv, p.min);
                Slot maxSlot = this.func_75147_a(p.inv, p.max);
                if (minSlot == null || maxSlot == null) continue;
                if (this.hasGhost(p)) {
                    for (int i = p.min; i <= p.max; ++i) {
                        if (this.func_75147_a(p.inv, i).func_75216_d() || !(this.func_75147_a(p.inv, i) instanceof SlotGhost)) continue;
                        this.func_75147_a(p.inv, i).func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)1));
                        this.func_75142_b();
                        return null;
                    }
                }
                if (!this.func_75135_a(itemstack1, minSlot.field_75222_d, maxSlot.field_75222_d + 1, false)) continue;
                merged = true;
                break;
            }
            if (!merged) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean backwards) {
        int l;
        ItemStack itemstack1;
        Slot slot;
        int k;
        boolean flag1 = false;
        int n = k = backwards ? end - 1 : start;
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!backwards && k < end || backwards && k >= start)) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (!slot.func_75214_a(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 != null && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1)) {
                    l = itemstack1.field_77994_a + stack.field_77994_a;
                    if (l <= stack.func_77976_d() && l <= slot.func_75219_a()) {
                        stack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        flag1 = true;
                    } else if (itemstack1.field_77994_a < stack.func_77976_d() && l < slot.func_75219_a()) {
                        stack.field_77994_a -= stack.func_77976_d() - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = stack.func_77976_d();
                        flag1 = true;
                    }
                }
                k += backwards ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = k = backwards ? end - 1 : start;
            while (!backwards && k < end || backwards && k >= start) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (!slot.func_75214_a(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 == null) {
                    l = stack.field_77994_a;
                    if (l <= slot.func_75219_a()) {
                        slot.func_75215_d(stack.func_77946_l());
                        stack.field_77994_a = 0;
                        flag1 = true;
                        break;
                    }
                    this.func_75141_a(k, new ItemStack(stack.func_77973_b(), slot.func_75219_a(), stack.func_77952_i()));
                    stack.field_77994_a -= slot.func_75219_a();
                    flag1 = true;
                }
                k += backwards ? -1 : 1;
            }
        }
        return flag1;
    }

    private final boolean hasGhost(Area area) {
        for (int i = area.min; i <= area.max; ++i) {
            if (!(this.func_75147_a(area.inv, i) instanceof SlotGhost)) continue;
            return true;
        }
        return false;
    }

    protected static class Area {
        IInventory inv;
        int min;
        int max;

        public Area(IInventory inv, int min, int max) {
            this.inv = inv;
            this.min = min;
            this.max = max;
        }
    }
}

