/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.datapart;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.datapart.CapabilityDataPart;
import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.helper.NBTHelper;
import mrriegel.limelib.network.DataPartSyncMessage;
import mrriegel.limelib.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public class DataPartRegistry
implements INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation LOCATION = new ResourceLocation("limelib:datapart");
    public static final BiMap<String, Class<? extends DataPart>> PARTS = HashBiMap.create();
    private Map<BlockPos, DataPart> partMap = Maps.newHashMap();
    public World world;

    public static DataPartRegistry get(World world) {
        DataPartRegistry reg;
        if (world == null) {
            return null;
        }
        DataPartRegistry dataPartRegistry = reg = world.hasCapability(CapabilityDataPart.DATAPART, null) ? (DataPartRegistry)world.getCapability(CapabilityDataPart.DATAPART, null) : null;
        if (reg == null) {
            return null;
        }
        if (reg.world == null) {
            reg.world = world;
        }
        for (DataPart part : reg.getParts()) {
            if (part.world != null) continue;
            part.world = world;
        }
        return reg;
    }

    public static void register(String name, Class<? extends DataPart> clazz) {
        PARTS.put((Object)name, clazz);
    }

    public DataPart getDataPart(BlockPos pos) {
        return this.partMap.get(pos);
    }

    public BlockPos nextPos(BlockPos pos) {
        HashSet set = Sets.newHashSet();
        int count = 0;
        while (this.getDataPart(pos) != null) {
            if (++count > 1000) {
                return null;
            }
            set.add(pos);
            while (set.contains(pos)) {
                pos = pos.func_177972_a(EnumFacing.field_82609_l[this.world.field_73012_v.nextInt(6)]);
            }
        }
        return pos;
    }

    public boolean addDataPart(BlockPos pos, DataPart part, boolean force) {
        Validate.notNull((Object)part);
        if (!PARTS.inverse().containsKey(part.getClass())) {
            LimeLib.log.error(part.getClass() + " not registered.");
            return false;
        }
        if (this.world.field_72995_K && !part.clientValid()) {
            return false;
        }
        part.pos = pos;
        part.world = this.world;
        if (this.partMap.get(pos) != null) {
            if (force) {
                this.partMap.put(pos, part);
                part.onAdded();
                this.sync(pos, true);
                return true;
            }
            return false;
        }
        this.partMap.put(pos, part);
        part.onAdded();
        this.sync(pos, true);
        return true;
    }

    public void removeDataPart(BlockPos pos) {
        if (this.partMap.containsKey(pos)) {
            this.partMap.get(pos).onRemoved();
            this.partMap.remove(pos);
            this.sync(pos, true);
        }
    }

    public void clearWorld() {
        this.partMap.clear();
    }

    public Collection<DataPart> getParts() {
        return Collections.unmodifiableCollection(this.partMap.values());
    }

    public void sync(BlockPos pos, boolean toAllPlayers) {
        if (this.world != null && !this.world.field_72995_K && (this.getDataPart(pos) == null || this.getDataPart(pos).clientValid())) {
            DataPartSyncMessage message = new DataPartSyncMessage(this.getDataPart(pos), pos, this.partMap.values().stream().map(DataPart::getPos).collect(Collectors.toList()));
            if (toAllPlayers) {
                for (EntityPlayer player : this.world.field_73010_i) {
                    PacketHandler.sendTo(message, (EntityPlayerMP)player);
                }
            } else {
                PacketHandler.sendToAllAround(message, new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 18.0));
            }
        }
    }

    public void sync(BlockPos pos) {
        this.sync(pos, false);
    }

    public NBTTagCompound serializeNBT() {
        ArrayList nbts = Lists.newArrayList();
        for (DataPart entry : this.partMap.values()) {
            nbts.add(entry.writeDataToNBT(new NBTTagCompound()));
        }
        return NBTHelper.setTagList(new NBTTagCompound(), "nbts", nbts);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.clearWorld();
        List<NBTTagCompound> nbts = NBTHelper.getTagList(nbt, "nbts");
        for (NBTTagCompound n : nbts) {
            this.createPart(n);
        }
    }

    public void createPart(NBTTagCompound n) {
        try {
            DataPart part;
            Class clazz = (Class)PARTS.get((Object)n.func_74779_i("id"));
            if (clazz != null && DataPart.class.isAssignableFrom(clazz) && (part = (DataPart)ConstructorUtils.invokeConstructor((Class)clazz, (Object[])new Object[0])) != null) {
                part.setWorld(this.world);
                part.readDataFromNBT(n);
                this.addDataPart(part.pos, part, true);
                return;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        LimeLib.log.error("Failed to create datapart " + n.func_74779_i("id"));
    }
}

