/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.book;

import com.google.common.collect.Lists;
import java.util.List;
import mrriegel.limelib.book.Article;
import mrriegel.limelib.book.Chapter;
import mrriegel.limelib.book.GuiBook;
import mrriegel.limelib.gui.GuiDrawer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Book {
    protected List<Chapter> chapters = Lists.newArrayList();
    public Chapter lastChapter;
    public Article lastArticle;
    public int lastPage;

    public void addChapter(Chapter c) {
        c.index = this.chapters.size();
        this.chapters.add(c);
    }

    public Pair<Integer, Integer> getPage(IForgeRegistryEntry<?> impl) {
        if (impl == null) {
            return null;
        }
        for (Chapter c : this.chapters) {
            if (c.implMap.get(impl) != null) {
                return ImmutablePair.of((Object)c.index, (Object)c.implMap.get(impl).index);
            }
            if (!(impl instanceof Item) || Block.func_149634_a((Item)((Item)impl)) == null || c.implMap.get(Block.func_149634_a((Item)((Item)impl))) == null) continue;
            return ImmutablePair.of((Object)c.index, (Object)c.implMap.get((Object)Block.func_149634_a((Item)((Item)impl))).index);
        }
        return null;
    }

    public void openGUI() {
        this.openGUI(-1, -1);
    }

    public void openGuiAt(IForgeRegistryEntry<?> impl, boolean openAnyway) {
        Pair<Integer, Integer> p = this.getPage(impl);
        if (p != null) {
            this.openGUI((Integer)p.getLeft(), (Integer)p.getRight());
        } else if (openAnyway) {
            this.openGUI();
        }
    }

    public void openGUI(int chapter, int article) {
        GuiDrawer.openGui(new GuiBook(this, chapter, article));
    }

    public boolean canOpen(IForgeRegistryEntry<?> impl) {
        return this.getPage(impl) != null;
    }
}

