/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.book;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class Article {
    protected String text;
    protected List<ItemStack> stacks = Lists.newArrayList();
    protected String name;
    protected int index;
    static final int maxItems = 10;

    public Article(String name) {
        this.name = name;
    }

    public Article(String name, ItemStack ... stacks) {
        this(name);
        for (ItemStack stack : stacks) {
            if (stack == null || this.stacks.size() >= 10) continue;
            this.stacks.add(stack);
        }
    }

    public Article(String name, IForgeRegistryEntry.Impl<?> ... impls) {
        this(name);
        for (IForgeRegistryEntry.Impl<?> impl : impls) {
            if (impl instanceof Item && this.stacks.size() < 10) {
                this.stacks.add(new ItemStack((Item)impl));
                continue;
            }
            if (!(impl instanceof Block) || this.stacks.size() >= 10) continue;
            this.stacks.add(new ItemStack((Block)impl));
        }
    }

    public Article setText(String text) {
        this.text = text;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Article other = (Article)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

