/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.block;

import com.google.common.collect.Lists;
import java.util.List;
import mrriegel.limelib.block.CommonBlock;
import mrriegel.limelib.helper.NBTStackHelper;
import mrriegel.limelib.helper.WorldHelper;
import mrriegel.limelib.tile.CommonTile;
import mrriegel.limelib.tile.IDataKeeper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public abstract class CommonBlockContainer<T extends CommonTile>
extends CommonBlock {
    protected boolean clearRecipe = true;

    public CommonBlockContainer(Material materialIn, String name) {
        super(materialIn, name);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) instanceof CommonTile) {
            for (ItemStack stack : ((CommonTile)worldIn.func_175625_s(pos)).getDroppingItems()) {
                if (stack == null) continue;
                CommonBlockContainer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack.func_77946_l());
            }
        }
        worldIn.func_175713_t(pos);
        worldIn.func_175666_e(pos, (Block)this);
    }

    @Override
    public void registerBlock() {
        super.registerBlock();
        GameRegistry.registerTileEntity(this.getTile(), (String)this.func_149739_a());
        if (this.clearRecipe && IDataKeeper.class.isAssignableFrom(this.getTile()) && !this.getItemBlock().func_77614_k()) {
            final ItemStack result = new ItemStack((Block)this);
            ShapelessRecipes r = new ShapelessRecipes(NBTStackHelper.setBoolean(new ItemStack((Block)this), "ClEaR", true), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this)})){

                public ItemStack func_77572_b(InventoryCrafting inv) {
                    return result;
                }
            };
            RecipeSorter.register((String)"limelib:idatakeeperClear", r.getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)r);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    protected abstract Class<? extends T> getTile();

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CommonTile) {
            return ((CommonTile)tile).openGUI((EntityPlayerMP)playerIn);
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List lis = super.getDrops(world, pos, state, fortune);
        ItemStack stack = null;
        TileEntity t = WorldHelper.getTile(world, pos);
        if (t instanceof IDataKeeper && lis.size() == 1 && ((ItemStack)lis.get(0)).func_77973_b() == Item.func_150898_a((Block)state.func_177230_c())) {
            IDataKeeper tile = (IDataKeeper)t;
            stack = ((ItemStack)lis.get(0)).func_77946_l();
            NBTStackHelper.setBoolean(stack, "idatakeeper", true);
            tile.writeToStack(stack);
        }
        return stack != null ? Lists.newArrayList((Object[])new ItemStack[]{stack}) : lis;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.func_175625_s(pos) instanceof IDataKeeper && NBTStackHelper.getBoolean(stack, "idatakeeper")) {
            IDataKeeper tile = (IDataKeeper)worldIn.func_175625_s(pos);
            tile.readFromStack(stack);
            worldIn.func_175625_s(pos).func_70296_d();
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        List<ItemStack> lis = this.getDrops((IBlockAccess)worldIn, pos, state, 0);
        if (!player.field_71075_bZ.field_75098_d && lis.size() == 1) {
            worldIn.func_175698_g(pos);
            CommonBlockContainer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)lis.get(0));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (player.func_70093_af() && player.field_71075_bZ.field_75098_d && world.func_175625_s(pos) instanceof IDataKeeper && stack != null) {
            IDataKeeper tile = (IDataKeeper)world.func_175625_s(pos);
            NBTStackHelper.setBoolean(stack, "idatakeeper", true);
            tile.writeToStack(stack);
        }
        return stack;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        if (this.clearRecipe && NBTStackHelper.getBoolean(stack, "ClEaR")) {
            tooltip.add(TextFormatting.YELLOW + "Clear content");
        }
    }
}

