/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.entity.passive;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.common.capabilities.CapabilityWolfArmor;
import com.google.common.base.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

@Deprecated
public class EntityWolfArmored
extends EntityWolf
implements IInventoryChangedListener {
    private AnimalChest inventory;
    private static final String NBT_TAG_HAS_CHEST = "hasChest";
    private static final String NBT_TAG_SLOT = "slot";
    private static final String NBT_TAG_INVENTORY = "inventory";
    private static final String NBT_TAG_ARMOR_ITEM = "armorItem";
    private static final DataParameter<Byte> HAS_CHEST = EntityDataManager.func_187226_a(EntityWolfArmored.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<ItemStack>> ARMOR_ITEM = EntityDataManager.func_187226_a(EntityWolfArmored.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityWolfArmored(@Nonnull World world) {
        super(world);
        this.inventoryInit();
    }

    protected void inventoryInit() {
        AnimalChest inventoryExisting = this.inventory;
        this.inventory = new AnimalChest("container.wolfarmor.wolf", 7);
        String customName = this.func_95999_t();
        if (!customName.isEmpty()) {
            this.inventory.func_110133_a(customName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int numberOfItemsExisting = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < numberOfItemsExisting; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot == null) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_CHEST, (Object)0);
        this.field_70180_af.func_187214_a(ARMOR_ITEM, (Object)Optional.absent());
    }

    public void func_70014_b(@Nonnull NBTTagCompound tags) {
        super.func_70014_b(tags);
        boolean entityHasChest = this.getHasChest();
        boolean entityHasArmor = this.getHasArmor();
        tags.func_74757_a(NBT_TAG_HAS_CHEST, entityHasChest);
        if (entityHasChest) {
            NBTTagList inventoryItemsTagList = new NBTTagList();
            for (byte slotIndex = 0; slotIndex < this.getInventory().func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = this.getInventory().func_70301_a((int)slotIndex);
                if (stackInSlot == null) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a(NBT_TAG_SLOT, slotIndex);
                stackInSlot.func_77955_b(slotTag);
                inventoryItemsTagList.func_74742_a((NBTBase)slotTag);
            }
            tags.func_74782_a(NBT_TAG_INVENTORY, (NBTBase)inventoryItemsTagList);
        }
        if (entityHasArmor) {
            ItemStack armorItem = this.getArmorItemStack();
            if (armorItem != null) {
                tags.func_74782_a(NBT_TAG_ARMOR_ITEM, (NBTBase)armorItem.func_77955_b(new NBTTagCompound()));
            } else {
                tags.func_82580_o(NBT_TAG_ARMOR_ITEM);
            }
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound tags) {
        NBTTagCompound armorTags;
        super.func_70037_a(tags);
        boolean entityHasChest = tags.func_150297_b(NBT_TAG_HAS_CHEST, 1) && tags.func_74767_n(NBT_TAG_HAS_CHEST);
        this.setHasChest(entityHasChest);
        if (entityHasChest) {
            this.inventoryInit();
            NBTTagList inventoryItemsTagList = tags.func_150295_c(NBT_TAG_INVENTORY, 10);
            for (int tagIndex = 0; tagIndex < inventoryItemsTagList.func_74745_c(); ++tagIndex) {
                NBTTagCompound itemTag = inventoryItemsTagList.func_150305_b(tagIndex);
                byte slotIndex = itemTag.func_74771_c(NBT_TAG_SLOT);
                if (slotIndex >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a((int)slotIndex, ItemStack.func_77949_a((NBTTagCompound)itemTag));
            }
        }
        if (!(armorTags = tags.func_74775_l(NBT_TAG_ARMOR_ITEM)).func_82582_d()) {
            ItemStack armorItemStack = ItemStack.func_77949_a((NBTTagCompound)armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    public void func_76316_a(@Nonnull InventoryBasic inventory) {
        ItemStack armor = inventory.func_70301_a(0);
        this.setArmorItemStack(armor);
    }

    private boolean equipArmor(@Nullable ItemStack armorItemStack) {
        if (!CapabilityWolfArmor.getIsValidWolfArmorItem(armorItemStack) || this.getHasArmor() && armorItemStack != null) {
            return false;
        }
        this.inventory.func_70299_a(0, armorItemStack);
        return true;
    }

    public boolean getHasChest() {
        return WolfArmorMod.getConfiguration().getIsWolfChestEnabled() && ((Byte)this.field_70180_af.func_187225_a(HAS_CHEST) & 2) != 0;
    }

    public void setHasChest(boolean value) {
        byte hasChest = (Byte)this.field_70180_af.func_187225_a(HAS_CHEST);
        if (value) {
            this.field_70180_af.func_187227_b(HAS_CHEST, (Object)((byte)(hasChest | 2)));
        } else {
            this.field_70180_af.func_187227_b(HAS_CHEST, (Object)((byte)(hasChest & 0xFFFFFFFD)));
        }
    }

    public boolean getHasArmor() {
        return this.getArmorItemStack() != null;
    }

    @Nonnull
    public IInventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public ItemStack getArmorItemStack() {
        Optional itemStackOptional = (Optional)this.field_70180_af.func_187225_a(ARMOR_ITEM);
        if (itemStackOptional.isPresent()) {
            ItemStack armorItemStack = (ItemStack)itemStackOptional.get();
            if (!CapabilityWolfArmor.getIsValidWolfArmorItem(armorItemStack.func_77973_b()) || armorItemStack.field_77994_a == 0) {
                this.field_70180_af.func_187227_b(ARMOR_ITEM, (Object)Optional.absent());
                return null;
            }
            return armorItemStack;
        }
        return null;
    }

    public void setArmorItemStack(@Nullable ItemStack armorItemStack) {
        ItemStack previousItemStack = this.getArmorItemStack();
        if (armorItemStack != null && (previousItemStack == null || previousItemStack.func_77973_b() != armorItemStack.func_77973_b())) {
            this.func_184606_a_(armorItemStack);
        }
        Optional itemStackOptional = Optional.fromNullable((Object)armorItemStack);
        if (CapabilityWolfArmor.getIsValidWolfArmorItem(armorItemStack)) {
            this.field_70180_af.func_187227_b(ARMOR_ITEM, (Object)itemStackOptional);
        }
    }
}

