/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.common.network.WolfArmorGuiHandler;
import com.attributestudios.wolfarmor.entity.passive.EntityWolfArmored;
import com.attributestudios.wolfarmor.event.WolfArmorEntityEventHandler;
import com.attributestudios.wolfarmor.event.WolfArmorPlayerEventHandler;
import com.attributestudios.wolfarmor.item.WolfArmorItems;
import com.attributestudios.wolfarmor.item.crafting.RecipeWolfArmorDyes;
import com.attributestudios.wolfarmor.item.crafting.WolfArmorRecipes;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public class CommonProxy {
    private static final Map<String, ResourceLocation> CACHED_RESOURCE_LOCATIONS = Maps.newHashMap();
    private boolean IsRenderSetted = false;

    public void preInit(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
        this.registerItems();
        this.registerItemRenderers(preInitializationEvent);
    }

    protected void registerEntityRenderingHandlers() {
    }

    protected void registerItems() {
        WolfArmorItems.init();
    }

    protected void registerItemRenderers(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
    }

    public void init(@Nonnull FMLInitializationEvent initializationEvent) {
        this.registerItemColorHandlers(initializationEvent);
        this.registerRecipes(initializationEvent);
        this.registerEventListeners(initializationEvent);
        this.registerEntities();
    }

    protected void registerItemColorHandlers(@Nonnull FMLInitializationEvent initializationEvent) {
    }

    @Deprecated
    protected void registerEntities() {
        EntityRegistry.registerModEntity(EntityWolfArmored.class, (String)"Wolf", (int)0, (Object)WolfArmorMod.instance, (int)80, (int)3, (boolean)false);
    }

    protected void registerRecipes(@Nonnull FMLInitializationEvent initializationEvent) {
        WolfArmorRecipes.init();
        RecipeSorter.register((String)"wolfarmor:WolfArmorDyes", RecipeWolfArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    protected void registerEventListeners(@Nonnull FMLInitializationEvent initializationEvent) {
        MinecraftForge.EVENT_BUS.register((Object)new WolfArmorEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WolfArmorPlayerEventHandler());
    }

    public void postInit(@Nonnull FMLPostInitializationEvent postInitializationEvent) {
        this.registerGuiHandlers(postInitializationEvent);
    }

    public void serverAboutToStart(@Nonnull FMLServerAboutToStartEvent event) {
        if (!this.IsRenderSetted) {
            this.IsRenderSetted = true;
            this.registerEntityRenderingHandlers();
        }
    }

    private void registerGuiHandlers(@Nonnull FMLPostInitializationEvent postInitializationEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)WolfArmorMod.instance, (IGuiHandler)new WolfArmorGuiHandler());
    }

    public ResourceLocation getResourceLocation(String path) {
        ResourceLocation resourceLocation = CACHED_RESOURCE_LOCATIONS.get(path);
        if (resourceLocation == null) {
            int index = path.indexOf(58);
            String domain = "wolfarmor";
            if (index > -1) {
                domain = path.substring(0, index);
                path = path.substring(index);
            }
            resourceLocation = new ResourceLocation(domain, path);
            CACHED_RESOURCE_LOCATIONS.put(path, resourceLocation);
        }
        return resourceLocation;
    }
}

