/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.dropdown;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.string.StringControllerElement;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public abstract class AbstractDropdownControllerElement<T, U>
extends StringControllerElement {
    public static final int MAX_SHOWN_NUMBER_OF_ITEMS = 7;
    private final AbstractDropdownController<T> dropdownController;
    protected boolean dropdownVisible = false;
    protected int selectedIndex = 0;
    protected List<U> matchingValues = null;

    public AbstractDropdownControllerElement(AbstractDropdownController<T> control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim, false);
        this.dropdownController = control;
        this.dropdownController.option.addListener((opt, val) -> {
            this.matchingValues = this.computeMatchingValues();
        });
    }

    public void showDropdown() {
        this.dropdownVisible = true;
        this.selectedIndex = 0;
    }

    public void closeDropdown() {
        this.dropdownVisible = false;
        this.ensureValidValue();
    }

    public void ensureValidValue() {
        this.inputField = this.dropdownController.getValidValue(this.inputField, this.selectedIndex);
        this.matchingValues = this.computeMatchingValues();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            if (!this.dropdownVisible) {
                this.showDropdown();
                this.doSelectAll();
            }
            return true;
        }
        return false;
    }

    @Override
    public void method_25365(boolean focused) {
        if (focused) {
            this.doSelectAll();
            super.method_25365(true);
        } else {
            this.unfocus();
        }
    }

    @Override
    public void unfocus() {
        this.closeDropdown();
        super.unfocus();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        if (this.dropdownVisible) {
            switch (keyCode) {
                case 264: {
                    this.selectNextEntry();
                    return true;
                }
                case 265: {
                    this.selectPreviousEntry();
                    return true;
                }
                case 258: {
                    if (class_437.method_25442()) {
                        this.selectPreviousEntry();
                    } else {
                        this.selectNextEntry();
                    }
                    return true;
                }
            }
        } else if (keyCode == 257 || keyCode == 335) {
            this.showDropdown();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        if (!this.dropdownVisible) {
            this.showDropdown();
        }
        return super.method_25400(chr, modifiers);
    }

    @Override
    protected int getValueColor() {
        if (this.inputFieldFocused && !this.dropdownController.isValueValid(this.inputField)) {
            return -1023872;
        }
        return super.getValueColor();
    }

    public void selectNextEntry() {
        this.selectedIndex = this.selectedIndex == this.getDropdownLength() - 1 ? 0 : ++this.selectedIndex;
    }

    public void selectPreviousEntry() {
        this.selectedIndex = this.selectedIndex == 0 ? this.getDropdownLength() - 1 : --this.selectedIndex;
    }

    public int getDropdownLength() {
        return this.matchingValues.size();
    }

    @Override
    public boolean modifyInput(Consumer<StringBuilder> builder) {
        boolean success = super.modifyInput(builder);
        if (success) {
            this.matchingValues = this.computeMatchingValues();
        }
        return success;
    }

    public abstract List<U> computeMatchingValues();

    public boolean matchingValue(String value) {
        return value.toLowerCase().contains(this.inputField.toLowerCase());
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.matchingValues == null) {
            this.matchingValues = this.computeMatchingValues();
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.inputFieldFocused && this.dropdownVisible) {
            class_4587 matrices = graphics.method_51448();
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 200.0f);
            this.renderDropdown(graphics);
            matrices.method_22909();
        }
    }

    public void renderDropdown(class_332 graphics) {
        if (this.matchingValues.isEmpty()) {
            return;
        }
        int begin = Math.max(0, this.selectedIndex - 3);
        int end = begin + 7;
        if (end >= this.matchingValues.size()) {
            end = this.matchingValues.size();
            begin = Math.max(0, end - 7);
        }
        this.renderDropdownBackground(graphics, end - begin);
        if (!this.matchingValues.isEmpty()) {
            graphics.method_51422(0.0f, 0.0f, 0.0f, 0.5f);
            int x = this.getDimension().x();
            int y = this.getDimension().yLimit() + 2 + this.getDimension().height() * (this.selectedIndex - begin);
            graphics.method_25294(x, y, x + this.getDimension().width(), y + this.getDimension().height(), -1);
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.method_49601(x, y, this.getDimension().width().intValue(), this.getDimension().height().intValue(), -1);
        }
        int n = 1;
        for (int i = begin; i < end; ++i) {
            this.renderDropdownEntry(graphics, this.matchingValues.get(i), n);
            ++n;
        }
    }

    protected int getDropdownEntryPadding() {
        return 0;
    }

    protected void renderDropdownEntry(class_332 graphics, U value, int n) {
        String entry = this.getString(value);
        int color = -1;
        Object text = entry.isBlank() ? class_2561.method_43471((String)"yacl.control.text.blank").method_27692(class_124.field_1080) : this.shortenString(entry);
        graphics.method_51439(this.textRenderer, text, this.getDimension().xLimit() - this.textRenderer.method_27525((class_5348)text) - this.getDecorationPadding() - this.getDropdownEntryPadding(), this.getTextY() + n * this.getDimension().height() + 2, color, true);
    }

    public abstract String getString(U var1);

    public class_2561 shortenString(String value) {
        return class_2561.method_43470((String)GuiUtils.shortenString(value, this.textRenderer, this.getDimension().width() - 20, "..."));
    }

    public void renderDropdownBackground(class_332 graphics, int numberOfItems) {
        graphics.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        graphics.method_25291(class_437.field_44669, this.getDimension().x().intValue(), this.getDimension().yLimit() + 2, 0, 0.0f, 0.0f, this.getDimension().width().intValue(), this.getDimension().height() * numberOfItems + 2, 32, 32);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.method_49601(this.getDimension().x().intValue(), this.getDimension().yLimit() + 2, this.getDimension().width().intValue(), this.getDimension().height() * numberOfItems, -1);
    }

    protected int getDecorationPadding() {
        return super.getXPadding();
    }
}

