/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class PipelineManager {
    private static PipelineManager instance;
    private final Function<NamespacedId, WorldRenderingPipeline> pipelineFactory;
    private final Map<NamespacedId, WorldRenderingPipeline> pipelinesPerDimension = new HashMap<NamespacedId, WorldRenderingPipeline>();
    private WorldRenderingPipeline pipeline = new FixedFunctionWorldRenderingPipeline();
    private int versionCounterForSodiumShaderReload = 0;

    public PipelineManager(Function<NamespacedId, WorldRenderingPipeline> function) {
        this.pipelineFactory = function;
    }

    public WorldRenderingPipeline preparePipeline(NamespacedId namespacedId) {
        if (!this.pipelinesPerDimension.containsKey(namespacedId)) {
            SystemTimeUniforms.COUNTER.reset();
            SystemTimeUniforms.TIMER.reset();
            Iris.logger.info("Creating pipeline for dimension {}", namespacedId);
            this.pipeline = this.pipelineFactory.apply(namespacedId);
            this.pipelinesPerDimension.put(namespacedId, this.pipeline);
            if (BlockRenderingSettings.INSTANCE.isReloadRequired()) {
                if (class_310.method_1551().field_1769 != null) {
                    class_310.method_1551().field_1769.method_3279();
                }
                BlockRenderingSettings.INSTANCE.clearReloadRequired();
            }
        } else {
            this.pipeline = this.pipelinesPerDimension.get(namespacedId);
        }
        return this.pipeline;
    }

    @Nullable
    public WorldRenderingPipeline getPipelineNullable() {
        return this.pipeline;
    }

    public Optional<WorldRenderingPipeline> getPipeline() {
        return Optional.ofNullable(this.pipeline);
    }

    public int getVersionCounterForSodiumShaderReload() {
        return this.versionCounterForSodiumShaderReload;
    }

    public void destroyPipeline() {
        this.pipelinesPerDimension.forEach((namespacedId, worldRenderingPipeline) -> {
            Iris.logger.info("Destroying pipeline {}", namespacedId);
            this.resetTextureState();
            worldRenderingPipeline.destroy();
        });
        this.pipelinesPerDimension.clear();
        this.pipeline = null;
        ++this.versionCounterForSodiumShaderReload;
    }

    private void resetTextureState() {
        for (int i = 0; i < 16; ++i) {
            GlStateManager.glActiveTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
    }
}

