/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.ServerConfigResponsePacket;
import dev.ftb.mods.ftbchunks.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTNet;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.nio.file.Path;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerConfigRequestPacket
extends BaseC2SMessage {
    private final SNBTCompoundTag config;

    public ServerConfigRequestPacket(SNBTCompoundTag config) {
        this.config = config;
    }

    public ServerConfigRequestPacket(FriendlyByteBuf buf) {
        this.config = SNBTNet.readCompound((FriendlyByteBuf)buf);
    }

    public MessageType getType() {
        return FTBChunksNet.SERVER_CONFIG_REQUEST;
    }

    public void write(FriendlyByteBuf buf) {
        SNBTNet.write((FriendlyByteBuf)buf, (Tag)this.config);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer sp;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_20310_(2)) {
            MinecraftServer server = sp.m_20194_();
            FTBChunks.LOGGER.info("FTB Chunks server config updated from client by player {}", (Object)sp.m_7755_().getString());
            FTBChunksWorldConfig.CONFIG.read(this.config);
            DimensionFilter.clearMatcherCaches();
            Path file = server.m_129843_(ConfigUtil.SERVER_CONFIG_DIR).resolve(FTBChunksWorldConfig.CONFIG.key + ".snbt");
            FTBChunksWorldConfig.CONFIG.save(file);
            for (ServerPlayer player2 : server.m_6846_().m_11314_()) {
                if (sp.m_20148_().equals(player2.m_20148_())) continue;
                new ServerConfigResponsePacket(this.config).sendTo(player2);
            }
            FTBTeamsAPI.api().getManager().getTeams().forEach(team -> ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team).updateLimits());
        }
    }
}

