/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.networking.packet;

import com.branders.spawnermod.item.SpawnerKeyItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncSpawnerMessage {
    private final BlockPos pos;
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public SyncSpawnerMessage(BlockPos pos, short delay, short spawnCount, short requiredPlayerRange, short maxNearbyEntities, short minSpawnDelay, short maxSpawnDelay) {
        this.pos = pos;
        this.delay = delay;
        this.minSpawnDelay = minSpawnDelay;
        this.maxSpawnDelay = maxSpawnDelay;
        this.spawnCount = spawnCount;
        this.maxNearbyEntities = maxNearbyEntities;
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public static void encode(SyncSpawnerMessage msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeShort((int)msg.delay);
        buf.writeShort((int)msg.maxNearbyEntities);
        buf.writeShort((int)msg.maxSpawnDelay);
        buf.writeShort((int)msg.minSpawnDelay);
        buf.writeShort((int)msg.requiredPlayerRange);
        buf.writeShort((int)msg.spawnCount);
    }

    public static SyncSpawnerMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = new BlockPos((Vec3i)buf.m_130135_());
        short delay = buf.readShort();
        short maxNearbyEntities = buf.readShort();
        short maxSpawnDelay = buf.readShort();
        short minSpawnDelay = buf.readShort();
        short requiredPlayerRange = buf.readShort();
        short spawnCount = buf.readShort();
        return new SyncSpawnerMessage(pos, delay, spawnCount, requiredPlayerRange, maxNearbyEntities, minSpawnDelay, maxSpawnDelay);
    }

    public static void handle(SyncSpawnerMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            if (level != null) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)level.m_7702_(msg.pos);
                BaseSpawner logic = spawner.m_59801_();
                BlockState blockstate = level.m_8055_(msg.pos);
                CompoundTag nbt = new CompoundTag();
                nbt = logic.m_186381_(nbt);
                if (msg.requiredPlayerRange == 0) {
                    nbt.m_128376_("SpawnRange", nbt.m_128448_("RequiredPlayerRange"));
                } else {
                    nbt.m_128376_("SpawnRange", (short)4);
                }
                nbt.m_128376_("Delay", msg.delay);
                nbt.m_128376_("SpawnCount", msg.spawnCount);
                nbt.m_128376_("RequiredPlayerRange", msg.requiredPlayerRange);
                nbt.m_128376_("MaxNearbyEntities", msg.maxNearbyEntities);
                nbt.m_128376_("MinSpawnDelay", msg.minSpawnDelay);
                nbt.m_128376_("MaxSpawnDelay", msg.maxSpawnDelay);
                logic.m_151328_(level, msg.pos, nbt);
                spawner.m_6596_();
                level.m_7260_(msg.pos, blockstate, blockstate, 3);
                ItemStack stack = ((NetworkEvent.Context)ctx.get()).getSender().m_21205_();
                if (stack.m_41720_() instanceof SpawnerKeyItem) {
                    stack.m_41622_(1, (LivingEntity)((NetworkEvent.Context)ctx.get()).getSender(), arg_0 -> SyncSpawnerMessage.lambda$handle$0((Supplier)ctx, arg_0));
                    level.m_46796_(3004, msg.pos, 0);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(Supplier ctx, LivingEntity player) {
        player.m_21190_(((NetworkEvent.Context)ctx.get()).getSender().m_7655_());
    }
}

