/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.networking.packet;

import com.branders.spawnermod.config.ConfigValues;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncSpawnerEggDrop {
    private final BlockPos pos;

    public SyncSpawnerEggDrop(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(SyncSpawnerEggDrop msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
    }

    public static SyncSpawnerEggDrop decode(FriendlyByteBuf buf) {
        BlockPos pos = new BlockPos((Vec3i)buf.m_130135_());
        return new SyncSpawnerEggDrop(pos);
    }

    public static void handle(SyncSpawnerEggDrop msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            if (level != null) {
                if (ConfigValues.get("disable_egg_removal_from_spawner") == 1) {
                    return;
                }
                BlockState blockstate = level.m_8055_(msg.pos);
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)level.m_7702_(msg.pos);
                BaseSpawner logic = spawner.m_59801_();
                CompoundTag nbt = new CompoundTag();
                String entity_string = (nbt = logic.m_186381_(nbt)).m_128423_("SpawnData").toString();
                if (entity_string.indexOf("\"") == -1) {
                    return;
                }
                entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
                if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).equalsIgnoreCase(EntityType.f_20476_.toString())) {
                    return;
                }
                ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entity_string + "_spawn_egg")));
                double d0 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
                double d1 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.06f + 0.6;
                double d2 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
                ItemEntity entityItem = new ItemEntity(level, (double)msg.pos.m_123341_() + d0, (double)msg.pos.m_123342_() + d1, (double)msg.pos.m_123343_() + d2, itemStack);
                entityItem.m_32060_();
                level.m_7967_((Entity)entityItem);
                logic.m_253197_(EntityType.f_20476_, level, level.f_46441_, msg.pos);
                spawner.m_6596_();
                level.m_7260_(msg.pos, blockstate, blockstate, 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

