/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.item;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.gui.SpawnerConfigGui;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnerKeyItem
extends Item {
    private static final Component TOOL_TIP = Component.m_237115_((String)"tooltip.spawnermod.spawner_key_disabled").m_130940_(ChatFormatting.RED);

    public SpawnerKeyItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (ConfigValues.get("disable_spawner_config") == 1) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (!level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos = context.m_8083_();
        if (level.m_8055_(blockpos).m_60734_() != Blocks.f_50085_) {
            return InteractionResult.PASS;
        }
        SpawnerBlockEntity spawner = (SpawnerBlockEntity)level.m_7702_(blockpos);
        BaseSpawner logic = spawner.m_59801_();
        this.openSpawnerGui(logic, blockpos);
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (ConfigValues.get("disable_spawner_config") == 1) {
            tooltip.add(TOOL_TIP);
            super.m_7373_(stack, level, tooltip, flagIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openSpawnerGui(BaseSpawner logic, BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new SpawnerConfigGui((Component)Component.m_237115_((String)""), logic, pos));
    }
}

