/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.SpawnerMod;
import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.item.SpawnerKeyItem;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerConfig;
import com.branders.spawnermod.networking.packet.SyncSpawnerEggDrop;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnerEventHandler {
    private Random random = new Random();

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        SpawnerMod.LOGGER.info("Sending config to player.");
        SpawnerModPacketHandler.INSTANCE.sendTo((Object)new SyncSpawnerConfig(ConfigValues.get("disable_spawner_config"), ConfigValues.get("disable_count"), ConfigValues.get("disable_speed"), ConfigValues.get("disable_range"), ConfigValues.get("limited_spawns_enabled"), ConfigValues.get("limited_spawns_amount"), ConfigValues.get("default_spawner_range_enabled"), ConfigValues.get("default_spawner_range")), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.getState().m_60734_() instanceof SpawnerBlock) {
            float newHardness = ConfigValues.get("spawner_hardness");
            float originalHardness = 5.0f;
            float dmg = event.getOriginalSpeed() / newHardness;
            float ticks = Math.round(1.0f / (dmg /= 100.0f));
            float seconds = ticks / 64.0f;
            float ticks2 = seconds * 64.0f;
            float dmg2 = 1.0f / ticks2;
            int newBreakSpeed = Math.round((dmg2 *= 100.0f) * originalHardness);
            event.setNewSpeed((float)newBreakSpeed);
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        ListTag list;
        if (event.getState().m_60734_() == Blocks.f_50085_ && this.checkSilkTouch(list = event.getPlayer().m_21205_().m_41785_()) && ConfigValues.get("disable_silk_touch") == 0) {
            event.setExpToDrop(0);
            if (ConfigValues.get("disable_egg_removal_from_spawner") == 0) {
                this.dropMonsterEgg(event.getPos(), (Level)event.getLevel());
            }
        }
    }

    @SubscribeEvent
    public void onNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        Level level = (Level)event.getLevel();
        for (Direction dir : Direction.values()) {
            BlockPos pos = event.getPos().m_121945_(dir);
            if (!(level.m_8055_(pos).m_60734_() instanceof SpawnerBlock)) continue;
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)level.m_7702_(pos);
            BaseSpawner logic = spawner.m_59801_();
            CompoundTag nbt = new CompoundTag();
            nbt = logic.m_186381_(nbt);
            if (level.m_276867_(pos)) {
                short value = nbt.m_128448_("RequiredPlayerRange");
                if (nbt.m_128448_("SpawnRange") > 4) {
                    return;
                }
                nbt.m_128376_("SpawnRange", value);
                nbt.m_128376_("RequiredPlayerRange", (short)0);
            } else {
                short pr = nbt.m_128448_("SpawnRange");
                if (pr <= 4) {
                    return;
                }
                nbt.m_128376_("RequiredPlayerRange", pr);
                nbt.m_128376_("SpawnRange", (short)4);
            }
            logic.m_151328_(level, pos, nbt);
            spawner.m_6596_();
            BlockState blockstate = level.m_8055_(pos);
            level.m_7260_(pos, blockstate, blockstate, 3);
        }
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        boolean causedByPlayer;
        boolean bl = causedByPlayer = event.getSource().m_7639_() instanceof Player;
        if (ConfigValues.get("monster_egg_only_drop_when_killed_by_player") == 1 && !causedByPlayer) {
            return;
        }
        if (this.random.nextFloat() > (float)ConfigValues.get("monster_egg_drop_chance") / 100.0f) {
            return;
        }
        LivingEntity entity = event.getEntity();
        EntityType entityType = entity.m_6095_();
        if (entityType.equals(EntityType.f_20532_)) {
            return;
        }
        String entityName = this.getEntityName(entityType);
        if (ConfigValues.isEggDisabled(entityName)) {
            return;
        }
        ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entityName + "_spawn_egg")));
        event.getDrops().add(new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemStack));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof BlockItem || item instanceof SpawnEggItem || item instanceof SpawnerKeyItem || event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        Level level = event.getLevel();
        if (!level.f_46443_ || event.getEntity().m_5833_()) {
            return;
        }
        BlockPos blockpos = event.getPos();
        if (level.m_8055_(blockpos).m_60734_() != Blocks.f_50085_) {
            return;
        }
        String registryName = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        if (ConfigValues.get("display_item_id_from_right_click_in_log") == 1) {
            SpawnerMod.LOGGER.info("Right clicked with item id: " + registryName);
        }
        if (ConfigValues.isItemIdBlacklisted(registryName)) {
            return;
        }
        SpawnerModPacketHandler.INSTANCE.sendToServer((Object)new SyncSpawnerEggDrop(blockpos));
    }

    private void dropMonsterEgg(BlockPos pos, Level level) {
        BlockState blockstate = level.m_8055_(pos);
        SpawnerBlockEntity spawner = (SpawnerBlockEntity)level.m_7702_(pos);
        BaseSpawner logic = spawner.m_59801_();
        CompoundTag nbt = new CompoundTag();
        String entity_string = (nbt = logic.m_186381_(nbt)).m_128423_("SpawnData").toString();
        if (entity_string.indexOf("\"") == -1) {
            return;
        }
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).equalsIgnoreCase(EntityType.f_20476_.toString())) {
            return;
        }
        ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entity_string + "_spawn_egg")));
        double d0 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
        double d1 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.06f + 0.6;
        double d2 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
        ItemEntity entityItem = new ItemEntity(level, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemStack);
        entityItem.m_32060_();
        level.m_7967_((Entity)entityItem);
        logic.m_253197_(EntityType.f_20476_, level, level.f_46441_, pos);
        spawner.m_6596_();
        level.m_7260_(pos, blockstate, blockstate, 3);
    }

    private boolean checkSilkTouch(ListTag list) {
        return list.m_7916_().indexOf("minecraft:silk_touch") != -1;
    }

    private String getEntityName(EntityType<?> entityType) {
        String entity = entityType.toString();
        String[] dotSplit = entity.split("\\.");
        String entityName = dotSplit[1] + ":" + dotSplit[2];
        return entityName;
    }
}

