/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.cobblegenrandomizer;

import com.horriblenerd.cobblegenrandomizer.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SEPARATOR = "\\|";
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_LISTS = "lists";
    public static final String CATEGORY_CUSTOM = "custom";
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.BooleanValue USE_CONFIG;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLOCK_LIST_COBBLE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLOCK_LIST_STONE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLOCK_LIST_BASALT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> CUSTOM_GENERATORS;
    private static final List<String> cobble;
    private static final List<String> stone;
    private static final List<String> basalt;
    private static final List<List<Object>> custom_gens;

    private static void initLists() {
        Config.addBlock(cobble, Blocks.f_50652_, 60);
        Config.addBlock(cobble, Blocks.f_49997_, 25);
        Config.addBlock(cobble, Blocks.f_49996_, 20);
        Config.addBlock(cobble, Blocks.f_50173_, 20);
        Config.addBlock(cobble, Blocks.f_50059_, 20);
        Config.addBlock(cobble, Blocks.f_50264_, 5);
        Config.addBlock(cobble, Blocks.f_49995_, 10);
        Config.addBlock(cobble, Blocks.f_50089_, 5);
        Config.addBlock(stone, Blocks.f_50069_, 30);
        Config.addBlock(stone, Blocks.f_50122_, 10);
        Config.addBlock(stone, Blocks.f_50228_, 10);
        Config.addBlock(stone, Blocks.f_50334_, 10);
        Config.addBlock(basalt, Blocks.f_50137_, 60);
        Config.addBlock(basalt, Blocks.f_50730_, 60);
        Config.addBlock(basalt, Blocks.f_50134_, 60);
        Config.addBlock(basalt, Blocks.f_50331_, 30);
        Config.addBlock(basalt, Blocks.f_49998_, 30);
        Config.addBlock(basalt, Blocks.f_50722_, 1);
    }

    private static void addBlock(List<String> list, Block block, int weight) {
        list.add(String.format("%s%s%d", Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)), SEPARATOR.replaceAll("\\\\", ""), weight));
    }

    private static void addBlock(List<String> list, Block block) {
        Config.addBlock(list, block, 1);
    }

    static {
        cobble = new ArrayList<String>();
        stone = new ArrayList<String>();
        basalt = new ArrayList<String>();
        custom_gens = new ArrayList<List<Object>>();
        Config.initLists();
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        USE_CONFIG = COMMON_BUILDER.comment("Use config instead of datapack").define("use_config", true);
        COMMON_BUILDER.comment(new String[]{"List settings", "Syntax: [\"modid:block|weight\"]", "Example: [\"minecraft:stone|2\",\"minecraft:dirt|1\"]", "Forge tags are supported"}).push(CATEGORY_LISTS);
        BLOCK_LIST_COBBLE = COMMON_BUILDER.comment("Cobble gen").defineList("block_list_cobble", cobble, b -> b instanceof String && (Util.isValidBlock((String)b) || Util.isValidTag((String)b)));
        BLOCK_LIST_STONE = COMMON_BUILDER.comment("Stone gen").defineList("block_list_stone", stone, b -> b instanceof String && (Util.isValidBlock((String)b) || Util.isValidTag((String)b)));
        BLOCK_LIST_BASALT = COMMON_BUILDER.comment("Basalt gen").defineList("block_list_basalt", basalt, b -> b instanceof String && (Util.isValidBlock((String)b) || Util.isValidTag((String)b)));
        COMMON_BUILDER.comment("Custom settings").push(CATEGORY_CUSTOM);
        CUSTOM_GENERATORS = COMMON_BUILDER.comment(new String[]{"Custom generators", "Syntax: [gen]", "Gen: [type, block, list]", "Type: cobblestone, stone", "Block: resource location of the block below the generated block", "List: see List settings", "Examples:", "custom_generators = [", "   [\"cobblestone\", \"minecraft:diamond_block\", [\"minecraft:diamond_block\"]],", "   [\"cobblestone\", \"minecraft:dirt\", [\"forge:dirt\"]],", "   [\"cobblestone\", \"minecraft:white_wool\", [\"minecraft:wool\"]]]"}).defineList("custom_generators", custom_gens, p -> p instanceof List && Util.isCustomGeneratorValid((List)p));
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

