/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.NumberConfig;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class IntConfig
extends NumberConfig<Integer> {
    public IntConfig(int mn, int mx) {
        super(mn, mx);
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if ((Integer)this.min != Integer.MIN_VALUE) {
            list.add(IntConfig.info("Min", this.formatValue((Integer)this.min)));
        }
        if ((Integer)this.max != Integer.MAX_VALUE) {
            list.add(IntConfig.info("Max", this.formatValue((Integer)this.max)));
        }
    }

    @Override
    public boolean parse(@Nullable Consumer<Integer> callback, String string) {
        try {
            int v = Long.decode(string).intValue();
            if (v >= (Integer)this.min && v <= (Integer)this.max) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected String formatValue(Integer v) {
        return String.format("%,d", v);
    }

    @Override
    public boolean scrollValue(boolean forward) {
        int newVal = Mth.m_14045_((int)((Integer)this.value + (forward ? 1 : -1)), (int)((Integer)this.min), (int)((Integer)this.max));
        if (newVal != (Integer)this.value) {
            this.setValue(newVal);
            return true;
        }
        return false;
    }
}

