/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops_common_forge.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "configurableextramobdrops";
    private static final File dir = new File(dirpath);
    private static final File file = new File(dirpath + File.separator + "mobdropconfig.txt");
    public static HashMap<EntityType<?>, CopyOnWriteArrayList<ItemStack>> mobdrops = new HashMap();
    private static final List<EntityType<?>> specialmiscmobs = new ArrayList<EntityType>(Arrays.asList(EntityType.f_20460_, EntityType.f_20528_, EntityType.f_20492_));

    public static void loadMobConfigFile() throws IOException {
        mobdrops = new HashMap();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "mobdropconfig.txt", StandardCharsets.UTF_8);
        } else {
            String configcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "mobdropconfig.txt", new String[0])), StandardCharsets.UTF_8);
            for (String line : configcontent.split("\n")) {
                String[] linespl;
                if (line.trim().endsWith(",")) {
                    line = line.trim();
                    line = line.substring(0, line.length() - 1).trim();
                }
                if (line.length() < 5 || !line.contains("' : '") || (linespl = line.split("' : '")).length < 2) continue;
                String entityrl = linespl[0].substring(1).trim();
                String itemstring = linespl[1].trim();
                itemstring = itemstring.substring(0, itemstring.length() - 1).trim();
                EntityType entitytype = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(entityrl));
                if (entitytype == null) continue;
                CopyOnWriteArrayList<ItemStack> thedrops = new CopyOnWriteArrayList<ItemStack>();
                if (itemstring.length() > 3) {
                    for (String itemdata : itemstring.split(StringFunctions.escapeSpecialRegexChars((String)"|||"))) {
                        ItemStack itemstack = null;
                        try {
                            CompoundTag newnbt = TagParser.m_129359_((String)itemdata);
                            itemstack = ItemStack.m_41712_((CompoundTag)newnbt);
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                        if (itemstack == null) continue;
                        thedrops.add(itemstack.m_41777_());
                    }
                }
                mobdrops.put(entitytype, thedrops);
            }
        }
        if (writer != null) {
            for (ResourceLocation rl : BuiltInRegistries.f_256780_.m_6566_()) {
                EntityType entitytype = (EntityType)BuiltInRegistries.f_256780_.m_7745_(rl);
                MobCategory classification = entitytype.m_20674_();
                if (classification.equals((Object)MobCategory.MISC) && !specialmiscmobs.contains(entitytype)) continue;
                writer.println("'" + rl.toString() + "' : '',");
                mobdrops.put(entitytype, new CopyOnWriteArrayList());
            }
            writer.close();
        }
    }

    public static boolean writeDropsMapToFile() throws IOException {
        if (!dir.isDirectory() || !file.isFile()) {
            dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "mobdropconfig.txt", StandardCharsets.UTF_8);
        for (ResourceLocation rl : BuiltInRegistries.f_256780_.m_6566_()) {
            CopyOnWriteArrayList<ItemStack> drops;
            EntityType entitytype = (EntityType)BuiltInRegistries.f_256780_.m_7745_(rl);
            MobCategory classification = entitytype.m_20674_();
            if (classification.equals((Object)MobCategory.MISC) && !specialmiscmobs.contains(entitytype)) continue;
            StringBuilder itemdata = new StringBuilder();
            if (mobdrops.containsKey(entitytype) && (drops = mobdrops.get(entitytype)).size() > 0) {
                for (ItemStack drop : drops) {
                    if (!itemdata.toString().equals("")) {
                        itemdata.append("|||");
                    }
                    CompoundTag nbt = new CompoundTag();
                    nbt = drop.m_41739_(nbt);
                    String nbtstring = nbt.toString();
                    itemdata.append(nbtstring);
                }
            }
            writer.println("'" + rl.toString() + "' : '" + itemdata + "',");
        }
        writer.close();
        return true;
    }
}

