/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops_common_forge.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.configurableextramobdrops_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class CommandCemd {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cemd").requires(iCommandSender -> iCommandSender.m_6761_(2))).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        })).then(Commands.m_82127_((String)"usage").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        }))).then(Commands.m_82127_((String)"list").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ArrayList<String> mobnames = new ArrayList<String>();
            for (EntityType<?> et : Util.mobdrops.keySet()) {
                String lowerregister = BuiltInRegistries.f_256780_.m_7981_(et).toString().toLowerCase();
                String[] nspl = lowerregister.split(":");
                if (nspl.length < 2) continue;
                String after = nspl[1];
                if (!nspl[0].equalsIgnoreCase("minecraft")) {
                    after = lowerregister.replace(":", "-");
                }
                mobnames.add(after);
            }
            Collections.sort(mobnames);
            StringBuilder output = new StringBuilder();
            for (String mobname : mobnames) {
                if (!output.toString().equals("")) {
                    output.append(", ");
                }
                output.append(mobname);
            }
            output.append(".");
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Available entity names:", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)output.toString(), (ChatFormatting)ChatFormatting.YELLOW);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"To add a drop: /cemd addhand <entity-name>", (ChatFormatting)ChatFormatting.DARK_GRAY);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Note: for modded entities use - not :", (ChatFormatting)ChatFormatting.RED);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }))).then(Commands.m_82127_((String)"reload").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                Util.loadMobConfigFile();
            }
            catch (Exception ex) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while reloading the mob drop config file.", (ChatFormatting)ChatFormatting.RED);
                ex.printStackTrace();
                return 0;
            }
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Successfully loaded the mob drop config file.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))).then(Commands.m_82127_((String)"addhand").then(Commands.m_82129_((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandCemd.processAddhand((CommandContext<CommandSourceStack>)command, 1.0))))).then(Commands.m_82127_((String)"addhand").then(Commands.m_82129_((String)"entity-name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"drop-chance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            double chance = DoubleArgumentType.getDouble((CommandContext)command, (String)"drop-chance");
            if (chance < 0.0 || chance > 1.0) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"The chance has to be in between 0 and 1.0.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            return CommandCemd.processAddhand((CommandContext<CommandSourceStack>)command, chance);
        }))))).then(Commands.m_82127_((String)"cleardrops").then(Commands.m_82129_((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            String entityname = StringArgumentType.getString((CommandContext)command, (String)"entity-name").toLowerCase().trim();
            EntityType<?> entitytype = null;
            for (EntityType<?> et : Util.mobdrops.keySet()) {
                String registrystring = BuiltInRegistries.f_256780_.m_7981_(et).toString();
                if (!registrystring.contains(":")) continue;
                if (entityname.contains("-")) {
                    if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                    entitytype = et;
                    break;
                }
                if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
                entitytype = et;
                break;
            }
            if (entitytype == null) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (ChatFormatting)ChatFormatting.RED);
                CommandCemd.showList(source);
                return 0;
            }
            if (!Util.mobdrops.containsKey(entitytype)) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (ChatFormatting)ChatFormatting.RED);
                CommandCemd.showList(source);
                return 0;
            }
            Util.mobdrops.put(entitytype, new CopyOnWriteArrayList());
            try {
                if (!Util.writeDropsMapToFile()) {
                    StringFunctions.sendMessage((CommandSourceStack)source, (String)"!Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
                }
            }
            catch (Exception ex) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
                ex.printStackTrace();
            }
            StringFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully cleared all drops for the entity '" + entitytype.m_20676_().getString() + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))));
    }

    private static int processAddhand(CommandContext<CommandSourceStack> command, double dropchance) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        try {
            player = source.m_81375_();
        }
        catch (CommandSyntaxException ex) {
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        String entityname = StringArgumentType.getString(command, (String)"entity-name").toLowerCase().trim();
        EntityType<?> entitytype = null;
        for (EntityType<?> et : Util.mobdrops.keySet()) {
            String registrystring = BuiltInRegistries.f_256780_.m_7981_(et).toString();
            if (!registrystring.contains(":")) continue;
            if (entityname.contains("-")) {
                if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                entitytype = et;
                break;
            }
            if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
            entitytype = et;
            break;
        }
        if (entitytype == null) {
            StringFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (ChatFormatting)ChatFormatting.RED);
            CommandCemd.showList(source);
            return 0;
        }
        if (!Util.mobdrops.containsKey(entitytype)) {
            StringFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (ChatFormatting)ChatFormatting.RED);
            CommandCemd.showList(source);
            return 0;
        }
        ItemStack hand = player.m_21205_();
        if (hand.m_41619_()) {
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Your hand is empty! Unable to add drop.", (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        ItemStack toadd = hand.m_41777_();
        CompoundTag nbt = toadd.m_41784_();
        nbt.m_128347_("dropchance", dropchance);
        toadd.m_41751_(nbt);
        Util.mobdrops.get(entitytype).add(toadd.m_41777_());
        try {
            if (!Util.writeDropsMapToFile()) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"!Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
            }
        }
        catch (Exception ex) {
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while writing the new config.", (ChatFormatting)ChatFormatting.RED);
            ex.printStackTrace();
        }
        StringFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully added '" + toadd.m_41613_() + " " + toadd.m_41786_().getString().toLowerCase() + "' as a drop for the entity '" + entitytype.m_20676_().getString() + "' with a drop chance of '" + dropchance + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }

    private static void showUsage(CommandSourceStack source) {
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"Configurable Extra Mob Drops Usage:", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd usage", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Show this message.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd list", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Lists available entities to add drops to.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd reload", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Reloads the config file.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd addhand <entity-name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Add your hand to the entity's drops with a 100% chance.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd addhand <entity-name> <drop-chance>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Add your hand to the entity's drops with drop-chance in between 0 and 1.0.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd cleardrops <entity-name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Clears all drops of the specified entity.", (ChatFormatting)ChatFormatting.DARK_GRAY);
    }

    private static void showList(CommandSourceStack source) {
        StringFunctions.sendMessage((CommandSourceStack)source, (String)" /cemd list", (ChatFormatting)ChatFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSourceStack)source, (String)"  Lists available entities to add drops to.", (ChatFormatting)ChatFormatting.DARK_GRAY);
    }
}

