/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class EmiGrindstoneDisenchantingRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraft", "textures/gui/container/grindstone.png");
    private final int uniq = EmiUtil.RANDOM.nextInt();
    private final Item tool;
    private final ResourceLocation id;

    public EmiGrindstoneDisenchantingRecipe(Item tool, ResourceLocation id) {
        this.tool = tool;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.GRINDING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((ItemLike)this.tool));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemLike)this.tool));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 116;
    }

    @Override
    public int getDisplayHeight() {
        return 56;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 116, 56, 30, 15);
        widgets.addGeneratedSlot(r -> this.getTool((Random)r, true), this.uniq, 18, 3).drawBack(false);
        widgets.addGeneratedSlot(r -> this.getTool((Random)r, false), this.uniq, 98, 18).drawBack(false).recipeContext(this);
    }

    private EmiStack getTool(Random random, Boolean enchanted) {
        ItemStack itemStack = new ItemStack((ItemLike)this.tool);
        int enchantments = 1 + Math.max(random.nextInt(5), random.nextInt(3));
        ArrayList list = Lists.newArrayList();
        block0: for (int i = 0; i < enchantments; ++i) {
            int lvl;
            Enchantment enchantment = this.getEnchantment(random);
            int maxLvl = enchantment.m_6586_();
            int minLvl = enchantment.m_44702_();
            int n = lvl = maxLvl > 0 ? random.nextInt(maxLvl) + 1 : 0;
            if (lvl < minLvl) {
                lvl = minLvl;
            }
            for (Enchantment e : list) {
                if (e != enchantment && e.m_44695_(enchantment)) continue;
                continue block0;
            }
            list.add(enchantment);
            if (enchantment.m_6589_()) {
                itemStack.m_41663_(enchantment, lvl);
                continue;
            }
            if (!enchanted.booleanValue()) continue;
            itemStack.m_41663_(enchantment, lvl);
        }
        return EmiStack.of(itemStack);
    }

    private Enchantment getEnchantment(Random random) {
        List<Enchantment> enchantments = EmiPort.getEnchantmentRegistry().m_123024_().filter(i -> i.m_6081_(this.tool.m_7968_())).toList();
        int enchantment = random.nextInt(enchantments.size());
        return enchantments.get(enchantment);
    }
}

