/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.jemi.JemiPlugin;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.platform.EmiAgnos;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class JemiUtil {
    public static EmiIngredient getIngredient(List<ITypedIngredient<?>> ingredients) {
        if (ingredients.isEmpty()) {
            return EmiStack.EMPTY;
        }
        return EmiIngredient.of(ingredients.stream().map(JemiUtil::getStack).filter(i -> !i.isEmpty()).toList());
    }

    public static EmiStack getStack(Object ingredient) {
        Optional optional = JemiPlugin.runtime.getIngredientManager().getIngredientTypeChecked(ingredient);
        if (optional.isPresent()) {
            return JemiUtil.getStack((IIngredientType)optional.get(), ingredient);
        }
        return EmiStack.EMPTY;
    }

    public static EmiStack getStack(ITypedIngredient<?> ingredient) {
        return JemiUtil.getStack(ingredient.getType(), ingredient.getIngredient());
    }

    public static EmiStack getStack(IIngredientType<?> type, Object ingredient) {
        if (type == VanillaTypes.ITEM_STACK) {
            return EmiStack.of((ItemStack)ingredient);
        }
        if (type == JemiUtil.getFluidType()) {
            return EmiAgnos.createFluidStack(ingredient);
        }
        IIngredientManager im = JemiPlugin.runtime.getIngredientManager();
        IIngredientHelper helper = im.getIngredientHelper(type);
        if (helper.isValidIngredient(ingredient)) {
            return new JemiStack<Object>(type, helper, im.getIngredientRenderer(type), ingredient);
        }
        return EmiStack.EMPTY;
    }

    public static Optional<ITypedIngredient<?>> getTyped(EmiStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Object object = stack.getKey();
        if (object instanceof Fluid) {
            Fluid f = (Fluid)object;
            return JemiPlugin.runtime.getIngredientManager().createTypedIngredient(JemiUtil.getFluidType(), JemiUtil.getFluidHelper().create(f, stack.getAmount() == 0L ? 1000L : stack.getAmount(), stack.getNbt()));
        }
        if (stack instanceof JemiStack) {
            JemiStack js = (JemiStack)stack;
            return JemiPlugin.runtime.getIngredientManager().getIngredientTypeChecked(js.ingredient).map(t -> JemiPlugin.runtime.getIngredientManager().createTypedIngredient(t, js.ingredient)).orElse(Optional.empty());
        }
        return JemiPlugin.runtime.getIngredientManager().createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack.getItemStack());
    }

    public static EmiStack getFluidFromJei(Object object) {
        if (object instanceof IJeiFluidIngredient) {
            IJeiFluidIngredient fluid = (IJeiFluidIngredient)object;
            return EmiStack.of(fluid.getFluid(), fluid.getTag().orElseGet(() -> null), fluid.getAmount());
        }
        return EmiStack.EMPTY;
    }

    public static IPlatformFluidHelper getFluidHelper() {
        return JemiPlugin.runtime.getJeiHelpers().getPlatformFluidHelper();
    }

    public static IIngredientType getFluidType() {
        return JemiUtil.getFluidHelper().getFluidIngredientType();
    }
}

