/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionAnyDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformReplaceSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformerReuseSerializer;
import com.blamejared.crafttweaker.mixin.common.access.registry.AccessMappedRegistry;
import com.mojang.serialization.Lifecycle;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class CraftTweakerRegistries {
    public static MappedRegistry<IIngredientTransformerSerializer<?>> REGISTRY_TRANSFORMER_SERIALIZER;
    public static MappedRegistry<IIngredientConditionSerializer<?>> REGISTRY_CONDITIONER_SERIALIZER;

    public static void init() {
        Registry registry = BuiltInRegistries.f_257047_;
        if (!(registry instanceof AccessMappedRegistry)) {
            throw new IllegalStateException("Unable to create new registries! Expected REGISTRY to be mapped, but was: '" + BuiltInRegistries.f_257047_.getClass() + "'");
        }
        AccessMappedRegistry registry2 = (AccessMappedRegistry)registry;
        boolean wasFrozen = registry2.crafttweaker$isFrozen();
        registry2.crafttweaker$setFrozen(false);
        REGISTRY_TRANSFORMER_SERIALIZER = CraftTweakerRegistries.registerRegistry(CraftTweakerConstants.rl("transformer_serializer"));
        REGISTRY_CONDITIONER_SERIALIZER = CraftTweakerRegistries.registerRegistry(CraftTweakerConstants.rl("condition_serializer"));
        registry2.crafttweaker$setFrozen(wasFrozen);
        CraftTweakerRegistries.registerSerializer(REGISTRY_TRANSFORMER_SERIALIZER, TransformReplaceSerializer.INSTANCE);
        CraftTweakerRegistries.registerSerializer(REGISTRY_TRANSFORMER_SERIALIZER, TransformDamageSerializer.INSTANCE);
        CraftTweakerRegistries.registerSerializer(REGISTRY_TRANSFORMER_SERIALIZER, TransformCustomSerializer.INSTANCE);
        CraftTweakerRegistries.registerSerializer(REGISTRY_TRANSFORMER_SERIALIZER, TransformerReuseSerializer.INSTANCE);
        CraftTweakerRegistries.registerSerializer(REGISTRY_CONDITIONER_SERIALIZER, ConditionDamagedSerializer.INSTANCE);
        CraftTweakerRegistries.registerSerializer(REGISTRY_CONDITIONER_SERIALIZER, ConditionAnyDamagedSerializer.INSTANCE);
        CraftTweakerRegistries.registerSerializer(REGISTRY_CONDITIONER_SERIALIZER, ConditionCustomSerializer.INSTANCE);
    }

    private static <T> MappedRegistry<T> registerRegistry(ResourceLocation location) {
        WritableRegistry registry = (WritableRegistry)BuiltInRegistries.f_257047_;
        ResourceKey regKey = ResourceKey.m_135788_((ResourceLocation)location);
        Lifecycle stable = Lifecycle.stable();
        MappedRegistry mappedReg = new MappedRegistry(regKey, stable);
        registry.m_255290_(regKey, (Object)mappedReg, stable);
        return mappedReg;
    }

    private static void registerSerializer(MappedRegistry<IIngredientTransformerSerializer<?>> registry, IIngredientTransformerSerializer<?> serializer) {
        registry.m_255290_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    private static void registerSerializer(MappedRegistry<IIngredientConditionSerializer<?>> registry, IIngredientConditionSerializer<?> serializer) {
        registry.m_255290_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }
}

