/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InterfaceClassFinder {
    public static List<Class<?>> getClassesImplementingInterface(Class<?> interfaceClass) {
        ArrayList implementingClasses = new ArrayList();
        for (Package pkg : Package.getPackages()) {
            String packageName = pkg.getName();
            List<Class<?>> packageClasses = InterfaceClassFinder.getClassesInPackage(packageName);
            for (Class<?> clazz : packageClasses) {
                if (!interfaceClass.isAssignableFrom(clazz)) continue;
                implementingClasses.add(clazz);
            }
        }
        return implementingClasses;
    }

    private static List<Class<?>> getClassesInPackage(String packageName) {
        ArrayList classes = new ArrayList();
        String packagePath = packageName.replace('.', '/');
        try {
            String[] classPaths;
            for (String classPath : classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
                File[] files;
                File file = new File(classPath + "/" + packagePath);
                if (!file.exists() || !file.isDirectory()) continue;
                for (File f : files = file.listFiles()) {
                    if (!f.isFile() || !f.getName().endsWith(".class")) continue;
                    String className = packageName + "." + f.getName().substring(0, f.getName().length() - 6);
                    Class<?> clazz = Class.forName(className);
                    classes.add(clazz);
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return classes;
    }
}

