/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.registries;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.motor.CreativeMotorGenerator;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockModel;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import com.simibubi.create.content.processing.AssemblyOperatorBlockItem;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.source.ItemNameDisplaySource;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import fr.iglee42.createcasing.CreateCasing;
import fr.iglee42.createcasing.blocks.customs.BrassShaftBlock;
import fr.iglee42.createcasing.blocks.customs.CreativeCogwheelBlock;
import fr.iglee42.createcasing.blocks.customs.CustomDepotBlock;
import fr.iglee42.createcasing.blocks.customs.CustomEncasedShaft;
import fr.iglee42.createcasing.blocks.customs.CustomGearboxBlock;
import fr.iglee42.createcasing.blocks.customs.CustomMixerBlock;
import fr.iglee42.createcasing.blocks.customs.CustomPressBlock;
import fr.iglee42.createcasing.blocks.customs.GlassShaftBlock;
import fr.iglee42.createcasing.blocks.customs.MLDEGShaftBlock;
import fr.iglee42.createcasing.blocks.customs.WoodenShaftBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedPipeBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedShaftBlock;
import fr.iglee42.createcasing.items.CustomVerticalGearboxItem;
import fr.iglee42.createcasing.registries.ModCreativeModeTabs;
import fr.iglee42.createcasing.registries.ModItems;
import fr.iglee42.createcasing.registries.ModSprites;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS;
    public static final BlockEntry<PublicEncasedShaftBlock> RAILWAY_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> COPPER_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> SHADOW_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> REFINED_RADIANCE_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> INDUSTRIAL_IRON_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedCogwheelBlock> RAILWAY_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> COPPER_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> SHADOW_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> RADIANCE_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> INDUSTRIAL_IRON_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> RAILWAY_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> COPPER_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> SHADOW_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> RADIANCE_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> INDUSTRIAL_IRON_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_ANDESITE_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_BRASS_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_RAILWAY_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_SHADOW_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_RADIANCE_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_INDUSTRIAL_IRON_FLUID_PIPE;
    public static final BlockEntry<CustomGearboxBlock> BRASS_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> COPPER_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> RAILWAY_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> INDUSTRIAL_IRON_GEARBOX;
    public static final BlockEntry<CustomMixerBlock> BRASS_MIXER;
    public static final BlockEntry<CustomMixerBlock> COPPER_MIXER;
    public static final BlockEntry<CustomMixerBlock> RAILWAY_MIXER;
    public static final BlockEntry<CustomMixerBlock> INDUSTRIAL_IRON_MIXER;
    public static final BlockEntry<CustomPressBlock> BRASS_PRESS;
    public static final BlockEntry<CustomPressBlock> COPPER_PRESS;
    public static final BlockEntry<CustomPressBlock> RAILWAY_PRESS;
    public static final BlockEntry<CustomPressBlock> INDUSTRIAL_IRON_PRESS;
    public static final BlockEntry<CustomDepotBlock> BRASS_DEPOT;
    public static final BlockEntry<CustomDepotBlock> COPPER_DEPOT;
    public static final BlockEntry<CustomDepotBlock> RAILWAY_DEPOT;
    public static final BlockEntry<CustomDepotBlock> INDUSTRIAL_IRON_DEPOT;
    public static final BlockEntry<WoodenShaftBlock> OAK_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> SPRUCE_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> BIRCH_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> JUNGLE_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> ACACIA_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> DARK_OAK_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> MANGROVE_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> CHERRY_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> BAMBOO_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> CRIMSON_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> WARPED_SHAFT;
    public static final BlockEntry<GlassShaftBlock> GLASS_SHAFT;
    public static final BlockEntry<BrassShaftBlock> BRASS_SHAFT;
    public static final BlockEntry<MLDEGShaftBlock> MLDEG_SHAFT;
    public static final BlockEntry<CreativeCogwheelBlock> CREATIVE_COGWHEEL;

    public static <B extends EncasedShaftBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedNoSpriteShaft(String casing) {
        return builder -> (BlockBuilder)ModBlocks.encasedBase(builder, () -> ((BlockEntry)AllBlocks.SHAFT).get()).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> p.models().getExistingFile(p.modLoc("block/encased_shaft/block_" + casing)), (boolean)true)).item().model(AssetLookup.customBlockItemModel((String[])new String[]{"encased_shaft", "item_" + casing})).build();
    }

    private static <B extends RotatedPillarKineticBlock, P> BlockBuilder<B, P> encasedBase(BlockBuilder<B, P> b, Supplier<ItemLike> drop) {
        return ((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)drop.get()));
    }

    private static BlockEntry<PublicEncasedShaftBlock> createShaft(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_shaft", p -> new PublicEncasedShaftBlock((BlockBehaviour.Properties)p, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedShaft((String)name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.SHAFT))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedCogwheelBlock> createCogwheel(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, CTSpriteShiftEntry sideSprite, CTSpriteShiftEntry otherSideSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, false, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedCogwheel((String)name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.COGWHEEL))).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(sprite, Couple.create((Object)sideSprite, (Object)otherSideSprite))))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedCogwheelBlock> createLargeCogwheel(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_large_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, true, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedLargeCogwheel((String)name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.LARGE_COGWHEEL))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedPipeBlock> createPipe(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_fluid_pipe", p -> new PublicEncasedPipeBlock((BlockBehaviour.Properties)p, casing)).initialProperties(SharedProperties::copperMetal).properties(p -> p.m_284180_(MapColor.f_283907_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.encasedPipe()).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(sprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, sprite, (s, f) -> (Boolean)s.m_61143_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false)))).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::new))).loot((p, b) -> p.m_246125_((Block)b, (ItemLike)AllBlocks.FLUID_PIPE.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.FLUID_PIPE))).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<CustomGearboxBlock> createGearbox(String name, CTSpriteShiftEntry sprite, ItemEntry<CustomVerticalGearboxItem> item) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_gearbox", p -> new CustomGearboxBlock((BlockBehaviour.Properties)p, item)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).transform(TagGen.axeOrPickaxe())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(sprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, sprite, (s, f) -> f.m_122434_() == s.m_61143_((Property)GearboxBlock.AXIS))))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]), (boolean)true)).item().transform(ModelGen.customItemModel())).register();
    }

    private static BlockEntry<CustomMixerBlock> createMixer(String name) {
        return Objects.equals(name, "brass") || Objects.equals(name, "copper") || Objects.equals(name, "railway") ? ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mixer", CustomMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283947_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).onRegisterAfter(Registries.f_256913_, v -> ItemDescription.useKey((ItemLike)v, (String)("block.createcasing." + name + "_mixer")))).addLayer(() -> RenderType::m_110457_).transform((NonNullFunction)BlockStressDefaults.setImpact((double)6.0))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register() : ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mixer", CustomMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283947_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).onRegisterAfter(Registries.f_256913_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.createcasing.custom_mixer"))).addLayer(() -> RenderType::m_110457_).transform((NonNullFunction)BlockStressDefaults.setImpact((double)4.0))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register();
    }

    private static BlockEntry<CustomPressBlock> createPress(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_press", CustomPressBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283819_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.horizontalBlockProvider((boolean)true)).transform((NonNullFunction)BlockStressDefaults.setImpact((double)8.0))).onRegisterAfter(Registries.f_256913_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.createcasing.custom_press"))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register();
    }

    private static BlockEntry<WoodenShaftBlock> createWoodenShaft(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_shaft", WoodenShaftBlock::new).initialProperties(SharedProperties::wooden).properties(p -> p.m_284180_(MapColor.f_283906_)).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).transform(TagGen.axeOnly())).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).simpleItem().register();
    }

    public static BlockEntry<CustomDepotBlock> createDepot(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_depot", CustomDepotBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283818_)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new ItemNameDisplaySource(), (String[])new String[]{"combine_item_names"}))).item().transform(ModelGen.customItemModel((String[])new String[]{"_", "block"}))).register();
    }

    public static void registerEncasedShafts() {
        ModBlocks.forEachShaft(shaft -> {
            Create.REGISTRATE.getAll(Registries.f_256747_).stream().filter(r -> r.getId().m_135815_().endsWith("_casing")).forEach(c -> {
                String casing = c.getId().m_135815_().replace("_casing", "");
                try {
                    CTSpriteShiftEntry sprite = (CTSpriteShiftEntry)AllSpriteShifts.class.getField(c.getId().m_135815_().toUpperCase()).get(new CTSpriteShiftEntry((CTType)AllCTTypes.OMNIDIRECTIONAL));
                    ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(casing + "_encased_" + shaft.getId().m_135815_(), p -> new CustomEncasedShaft((BlockBehaviour.Properties)p, (Supplier<Block>)c, (Supplier<? extends Block>)shaft)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedShaft((String)casing, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)shaft))).transform(TagGen.axeOrPickaxe())).loot((l, s) -> l.m_246125_((Block)s, (ItemLike)s.getShaft().get().m_5456_())).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).register();
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    ex.printStackTrace();
                }
            });
            ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("industrial_iron_encased_" + shaft.getId().m_135815_(), p -> new CustomEncasedShaft((BlockBehaviour.Properties)p, (Supplier<Block>)AllBlocks.INDUSTRIAL_IRON_BLOCK, (Supplier<? extends Block>)shaft)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(ModBlocks.encasedNoSpriteShaft("industrial_iron"))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)shaft))).transform(TagGen.axeOrPickaxe())).loot((l, s) -> l.m_246125_((Block)s, (ItemLike)s.getShaft().get().m_5456_())).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).register();
        });
    }

    public static void register() {
    }

    public static boolean isWoodenShaftHasState(BlockState state) {
        return OAK_SHAFT.has(state) || SPRUCE_SHAFT.has(state) || BIRCH_SHAFT.has(state) || JUNGLE_SHAFT.has(state) || ACACIA_SHAFT.has(state) || DARK_OAK_SHAFT.has(state) || MANGROVE_SHAFT.has(state) || BAMBOO_SHAFT.has(state) || CHERRY_SHAFT.has(state) || CRIMSON_SHAFT.has(state) || WARPED_SHAFT.has(state);
    }

    public static void forEachShaft(Consumer<BlockEntry<? extends ShaftBlock>> action) {
        action.accept(OAK_SHAFT);
        action.accept(BIRCH_SHAFT);
        action.accept(SPRUCE_SHAFT);
        action.accept(JUNGLE_SHAFT);
        action.accept(ACACIA_SHAFT);
        action.accept(DARK_OAK_SHAFT);
        action.accept(MANGROVE_SHAFT);
        action.accept(BAMBOO_SHAFT);
        action.accept(CHERRY_SHAFT);
        action.accept(WARPED_SHAFT);
        action.accept(CRIMSON_SHAFT);
        action.accept(GLASS_SHAFT);
        action.accept(MLDEG_SHAFT);
    }

    static {
        CreateCasing.REGISTRATE.setCreativeTab(ModCreativeModeTabs.MAIN_TAB);
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"createcasing");
        RAILWAY_ENCASED_SHAFT = ModBlocks.createShaft("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING);
        COPPER_ENCASED_SHAFT = ModBlocks.createShaft("copper", () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), AllSpriteShifts.COPPER_CASING);
        SHADOW_ENCASED_SHAFT = ModBlocks.createShaft("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING);
        REFINED_RADIANCE_ENCASED_SHAFT = ModBlocks.createShaft("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING);
        INDUSTRIAL_IRON_ENCASED_SHAFT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("industrial_iron_encased_shaft", p -> new PublicEncasedShaftBlock((BlockBehaviour.Properties)p, (Supplier<Block>)AllBlocks.INDUSTRIAL_IRON_BLOCK)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(ModBlocks.encasedNoSpriteShaft("industrial_iron"))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.SHAFT))).transform(TagGen.axeOrPickaxe())).register();
        RAILWAY_ENCASED_COGWHEEL = ModBlocks.createCogwheel("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING, ModSprites.RAILWAY_ENCASED_COGWHEEL_SIDE, ModSprites.RAILWAY_ENCASED_COGWHEEL_OTHERSIDE);
        COPPER_ENCASED_COGWHEEL = ModBlocks.createCogwheel("copper", () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), AllSpriteShifts.COPPER_CASING, ModSprites.COPPER_ENCASED_COGWHEEL_SIDE, ModSprites.COPPER_ENCASED_COGWHEEL_OTHERSIDE);
        SHADOW_ENCASED_COGWHEEL = ModBlocks.createCogwheel("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING, ModSprites.SHADOW_ENCASED_COGWHEEL_SIDE, ModSprites.SHADOW_ENCASED_COGWHEEL_OTHERSIDE);
        RADIANCE_ENCASED_COGWHEEL = ModBlocks.createCogwheel("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING, ModSprites.RADIANCE_ENCASED_COGWHEEL_SIDE, ModSprites.RADIANCE_ENCASED_COGWHEEL_OTHERSIDE);
        INDUSTRIAL_IRON_ENCASED_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("industrial_iron_encased_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, false, (Supplier<Block>)AllBlocks.INDUSTRIAL_IRON_BLOCK)).properties(p -> p.m_284180_(MapColor.f_283819_).m_60955_()).addLayer(() -> RenderType::m_110457_).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.COGWHEEL))).transform(TagGen.axeOrPickaxe())).item().transform(ModelGen.customItemModel())).register();
        RAILWAY_ENCASED_COGWHEEL_LARGE = ModBlocks.createLargeCogwheel("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING);
        COPPER_ENCASED_COGWHEEL_LARGE = ModBlocks.createLargeCogwheel("copper", () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), AllSpriteShifts.COPPER_CASING);
        SHADOW_ENCASED_COGWHEEL_LARGE = ModBlocks.createLargeCogwheel("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING);
        RADIANCE_ENCASED_COGWHEEL_LARGE = ModBlocks.createLargeCogwheel("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING);
        INDUSTRIAL_IRON_ENCASED_COGWHEEL_LARGE = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("industrial_iron_encased_large_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, true, (Supplier<Block>)AllBlocks.INDUSTRIAL_IRON_BLOCK)).properties(p -> p.m_284180_(MapColor.f_283819_).m_60955_()).addLayer(() -> RenderType::m_110457_).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.LARGE_COGWHEEL))).transform(TagGen.axeOrPickaxe())).item().transform(ModelGen.customItemModel())).register();
        ENCASED_ANDESITE_FLUID_PIPE = ModBlocks.createPipe("andesite", () -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get(), AllSpriteShifts.ANDESITE_CASING);
        ENCASED_BRASS_FLUID_PIPE = ModBlocks.createPipe("brass", () -> ((BlockEntry)AllBlocks.BRASS_CASING).get(), AllSpriteShifts.BRASS_CASING);
        ENCASED_RAILWAY_FLUID_PIPE = ModBlocks.createPipe("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING);
        ENCASED_SHADOW_FLUID_PIPE = ModBlocks.createPipe("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING);
        ENCASED_RADIANCE_FLUID_PIPE = ModBlocks.createPipe("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING);
        ENCASED_INDUSTRIAL_IRON_FLUID_PIPE = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("industrial_iron_encased_fluid_pipe", p -> new PublicEncasedPipeBlock((BlockBehaviour.Properties)p, (Supplier<Block>)AllBlocks.INDUSTRIAL_IRON_BLOCK)).initialProperties(SharedProperties::copperMetal).properties(p -> p.m_284180_(MapColor.f_283907_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::new))).loot((p, b) -> p.m_246125_((Block)b, (ItemLike)AllBlocks.FLUID_PIPE.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.FLUID_PIPE))).register();
        BRASS_GEARBOX = ModBlocks.createGearbox("brass", AllSpriteShifts.BRASS_CASING, ModItems.VERTICAL_BRASS_GEARBOX);
        COPPER_GEARBOX = ModBlocks.createGearbox("copper", AllSpriteShifts.COPPER_CASING, ModItems.VERTICAL_COPPER_GEARBOX);
        RAILWAY_GEARBOX = ModBlocks.createGearbox("railway", AllSpriteShifts.RAILWAY_CASING, ModItems.VERTICAL_RAILWAY_GEARBOX);
        INDUSTRIAL_IRON_GEARBOX = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("industrial_iron_gearbox", p -> new CustomGearboxBlock((BlockBehaviour.Properties)p, ModItems.VERTICAL_INDUSTRIAL_IRON_GEARBOX)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]), (boolean)true)).item().transform(ModelGen.customItemModel())).register();
        BRASS_MIXER = ModBlocks.createMixer("brass");
        COPPER_MIXER = ModBlocks.createMixer("copper");
        RAILWAY_MIXER = ModBlocks.createMixer("railway");
        INDUSTRIAL_IRON_MIXER = ModBlocks.createMixer("industrial_iron");
        BRASS_PRESS = ModBlocks.createPress("brass");
        COPPER_PRESS = ModBlocks.createPress("copper");
        RAILWAY_PRESS = ModBlocks.createPress("railway");
        INDUSTRIAL_IRON_PRESS = ModBlocks.createPress("industrial_iron");
        BRASS_DEPOT = ModBlocks.createDepot("brass");
        COPPER_DEPOT = ModBlocks.createDepot("copper");
        RAILWAY_DEPOT = ModBlocks.createDepot("railway");
        INDUSTRIAL_IRON_DEPOT = ModBlocks.createDepot("industrial_iron");
        OAK_SHAFT = ModBlocks.createWoodenShaft("oak");
        SPRUCE_SHAFT = ModBlocks.createWoodenShaft("spruce");
        BIRCH_SHAFT = ModBlocks.createWoodenShaft("birch");
        JUNGLE_SHAFT = ModBlocks.createWoodenShaft("jungle");
        ACACIA_SHAFT = ModBlocks.createWoodenShaft("acacia");
        DARK_OAK_SHAFT = ModBlocks.createWoodenShaft("dark_oak");
        MANGROVE_SHAFT = ModBlocks.createWoodenShaft("mangrove");
        CHERRY_SHAFT = ModBlocks.createWoodenShaft("bamboo");
        BAMBOO_SHAFT = ModBlocks.createWoodenShaft("cherry");
        CRIMSON_SHAFT = ModBlocks.createWoodenShaft("crimson");
        WARPED_SHAFT = ModBlocks.createWoodenShaft("warped");
        GLASS_SHAFT = ((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("glass_shaft", GlassShaftBlock::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_56744_).m_60955_()).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).simpleItem().register();
        BRASS_SHAFT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("brass_shaft", BrassShaftBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_284180_(MapColor.f_283906_)).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).transform(TagGen.axeOnly())).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).simpleItem().register();
        MLDEG_SHAFT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("mldeg_shaft", MLDEGShaftBlock::new).initialProperties(() -> Blocks.f_50730_).properties(p -> p.m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_56742_).m_60955_()).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).blockstate(BlockStateGen.axisBlockProvider((boolean)false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).onRegisterAfter(Registries.f_256913_, CreateCasing::hideItem)).simpleItem().register();
        CREATIVE_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("creative_cogwheel", CreativeCogwheelBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283889_)).properties(BlockBehaviour.Properties::m_60955_).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).transform(TagGen.pickaxeOnly())).blockstate((arg_0, arg_1) -> ((CreativeMotorGenerator)new CreativeMotorGenerator()).generate(arg_0, arg_1)).transform((NonNullFunction)BlockStressDefaults.setCapacity((double)16384.0))).transform((NonNullFunction)BlockStressDefaults.setGeneratorSpeed(() -> Couple.create((Object)0, (Object)256)))).addLayer(() -> RenderType::m_110457_).item().properties(p -> p.m_41497_(Rarity.EPIC)).transform(ModelGen.customItemModel())).register();
    }
}

