/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.api;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.processing.AssemblyOperatorBlockItem;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.source.ItemNameDisplaySource;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import fr.iglee42.createcasing.blocks.api.ApiDepotBlock;
import fr.iglee42.createcasing.blocks.api.ApiGearboxBlock;
import fr.iglee42.createcasing.blocks.api.ApiMixerBlock;
import fr.iglee42.createcasing.blocks.api.ApiPressBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedPipeBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedShaftBlock;
import fr.iglee42.createcasing.items.ApiVerticalGearboxItem;
import fr.iglee42.createcasing.registries.ModBlocks;
import fr.iglee42.createcasing.utils.Deferred;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class CreateCasingApi {
    public static BlockEntry<CasingBlock> createCasing(CreateRegistrate registrate, String name, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)registrate.block(name + "_casing", CasingBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.casing(() -> connectedTexturesSprite))).register();
    }

    public static BlockEntry<PublicEncasedShaftBlock> createEncasedShaft(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_shaft", p -> new PublicEncasedShaftBlock((BlockBehaviour.Properties)p, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedShaft((String)name, () -> connectedTexturesSprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.SHAFT))).transform(TagGen.axeOrPickaxe())).register();
    }

    public static BlockEntry<PublicEncasedCogwheelBlock> createEncasedCogwheel(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite, CTSpriteShiftEntry verticalCogwheelSide, CTSpriteShiftEntry horizontalCogwheelSide) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, false, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedCogwheel((String)name, () -> connectedTexturesSprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.COGWHEEL))).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(connectedTexturesSprite, Couple.create((Object)verticalCogwheelSide, (Object)horizontalCogwheelSide))))).transform(TagGen.axeOrPickaxe())).register();
    }

    public static BlockEntry<PublicEncasedCogwheelBlock> createEncasedLargeCogwheel(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_large_cogwheel", p -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, true, casing)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BuilderTransformers.encasedLargeCogwheel((String)name, () -> connectedTexturesSprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.LARGE_COGWHEEL))).transform(TagGen.axeOrPickaxe())).register();
    }

    public static BlockEntry<PublicEncasedPipeBlock> createEncasedPipe(CreateRegistrate registrate, String name, Supplier<Block> casing, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_encased_fluid_pipe", p -> new PublicEncasedPipeBlock((BlockBehaviour.Properties)p, casing)).initialProperties(SharedProperties::copperMetal).properties(p -> p.m_284180_(MapColor.f_283907_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.encasedPipe()).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(connectedTexturesSprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, connectedTexturesSprite, (s, f) -> (Boolean)s.m_61143_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false)))).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::new))).loot((p, b) -> p.m_246125_((Block)b, (ItemLike)AllBlocks.FLUID_PIPE.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.FLUID_PIPE))).register();
    }

    public static BlockEntry<ApiGearboxBlock> createGearbox(CreateRegistrate registrate, String name, CTSpriteShiftEntry connectedTexturesSprite, boolean shouldGenerateVerticalItem) {
        if (shouldGenerateVerticalItem) {
            Deferred<ItemEntry> itemEntryDeferred = new Deferred<ItemEntry>();
            BlockEntry gearbox = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_gearbox", p -> new ApiGearboxBlock((BlockBehaviour.Properties)p, (Deferred<ItemEntry<ApiVerticalGearboxItem>>)itemEntryDeferred)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).transform(TagGen.axeOrPickaxe())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(connectedTexturesSprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, connectedTexturesSprite, (s, f) -> f.m_122434_() == s.m_61143_((Property)GearboxBlock.AXIS))))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]), (boolean)true)).item().transform(ModelGen.customItemModel())).register();
            itemEntryDeferred.set(registrate.item("vertical_" + name + "_gearbox", p -> new ApiVerticalGearboxItem((Item.Properties)p, (Block)gearbox.get())).model(AssetLookup.customBlockItemModel((String[])new String[]{name + "_gearbox", "item_vertical"})).register());
            return gearbox;
        }
        BlockEntry gearbox = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_gearbox", p -> new ApiGearboxBlock((BlockBehaviour.Properties)p, null)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_)).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).transform(TagGen.axeOrPickaxe())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(connectedTexturesSprite)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, connectedTexturesSprite, (s, f) -> f.m_122434_() == s.m_61143_((Property)GearboxBlock.AXIS))))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]), (boolean)true)).item().transform(ModelGen.customItemModel())).register();
        return gearbox;
    }

    public static BlockEntry<ApiDepotBlock> createDepot(CreateRegistrate registrate, String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_depot", ApiDepotBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283818_)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new ItemNameDisplaySource(), (String[])new String[]{"combine_item_names"}))).item().transform(ModelGen.customItemModel((String[])new String[]{"_", "block"}))).register();
    }

    public static BlockEntry<ApiMixerBlock> createMixer(CreateRegistrate registrate, String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_mixer", ApiMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283947_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0]))).addLayer(() -> RenderType::m_110457_).transform((NonNullFunction)BlockStressDefaults.setImpact((double)4.0))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register();
    }

    public static BlockEntry<ApiPressBlock> createPress(CreateRegistrate registrate, String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(name + "_press", ApiPressBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.m_60955_().m_284180_(MapColor.f_283819_)).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.horizontalBlockProvider((boolean)true)).transform((NonNullFunction)BlockStressDefaults.setImpact((double)8.0))).item(AssemblyOperatorBlockItem::new).transform(ModelGen.customItemModel())).register();
    }

    public static void forCustomShafts(Consumer<BlockEntry<? extends ShaftBlock>> action) {
        ModBlocks.forEachShaft(action);
    }
}

