/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import fr.iglee42.createcasing.CreateCasingClient;
import fr.iglee42.createcasing.compat.kubejs.KubeJSCompatInit;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.registries.ModBlockEntities;
import fr.iglee42.createcasing.registries.ModBlocks;
import fr.iglee42.createcasing.registries.ModCreativeModeTabs;
import fr.iglee42.createcasing.registries.ModPackets;
import fr.iglee42.createcasing.registries.ModSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="createcasing")
public class CreateCasing {
    public static final String MODID = "createcasing";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"createcasing");
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"createcasing");
    public static List<ItemLike> hidedItems = new ArrayList<ItemLike>();

    public CreateCasing() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ModConfigs.register(ModLoadingContext.get());
        REGISTRATE.registerEventListeners(FMLJavaModLoadingContext.get().getModEventBus());
        Create.REGISTRATE.addRegisterCallback(Registries.f_256747_, ModBlocks::registerEncasedShafts);
        ModSounds.prepare();
        ModBlocks.register();
        ModBlockEntities.register();
        ModCreativeModeTabs.register(modEventBus);
        ModPackets.registerPackets();
        if (ModList.get().isLoaded("kubejs")) {
            KubeJSCompatInit.init();
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateCasingClient.onCtorClient(modEventBus, forgeEventBus));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        forgeEventBus.addListener(this::onPlayerRightClickOnBlock);
        modEventBus.addListener(ModSounds::register);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static boolean isExtendedCogsLoaded() {
        return ModList.get().isLoaded("extendedgears");
    }

    public static void hideItem(ItemLike it) {
        hidedItems.add(it);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    public static boolean isCrystalClearLoaded() {
        return ModList.get().isLoaded("create_crystal_clear");
    }

    private void onPlayerRightClickOnBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getEntity().m_9236_();
        if (event.getItemStack().m_41619_()) {
            return;
        }
        if (AllBlocks.MECHANICAL_PRESS.has(world.m_8055_(event.getPos()))) {
            BlockState blockState = world.m_8055_(event.getPos());
            Direction facing = (Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
            if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.BRASS_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), (BlockState)ModBlocks.BRASS_PRESS.getDefaultState().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.COPPER_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), (BlockState)ModBlocks.COPPER_PRESS.getDefaultState().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.RAILWAY_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), (BlockState)ModBlocks.RAILWAY_PRESS.getDefaultState().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((Block)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()).m_5456_())) {
                world.m_46597_(event.getPos(), (BlockState)ModBlocks.INDUSTRIAL_IRON_PRESS.getDefaultState().m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        } else if (AllBlocks.MECHANICAL_MIXER.has(world.m_8055_(event.getPos()))) {
            if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.BRASS_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.BRASS_MIXER.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.COPPER_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.COPPER_MIXER.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.RAILWAY_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.RAILWAY_MIXER.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((Block)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.INDUSTRIAL_IRON_MIXER.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        } else if (AllBlocks.DEPOT.has(world.m_8055_(event.getPos()))) {
            if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.BRASS_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.BRASS_DEPOT.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.COPPER_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.COPPER_DEPOT.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((CasingBlock)AllBlocks.RAILWAY_CASING.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.RAILWAY_DEPOT.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (event.getItemStack().m_150930_(((Block)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()).m_5456_())) {
                world.m_46597_(event.getPos(), ModBlocks.INDUSTRIAL_IRON_DEPOT.getDefaultState());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

