/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.jei;

import com.blamejared.jeitweaker.common.api.JeiTweakerConstants;
import com.blamejared.jeitweaker.common.util.JeiCategoriesState;
import com.blamejared.jeitweaker.common.util.UnintuitiveApiHelper;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;

@JeiPlugin
public final class JeiTweakerCommandJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = JeiTweakerConstants.rl("command");

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.storeCategories(jeiRuntime);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    private void storeCategories(IJeiRuntime runtime) {
        JeiCategoriesState.get().registerStatesProvider((visible, hidden) -> this.states(runtime, (JeiCategoriesState.JeiCategoryState.Creator)visible, (JeiCategoriesState.JeiCategoryState.Creator)hidden));
    }

    private Set<JeiCategoriesState.JeiCategoryState> states(IJeiRuntime runtime, JeiCategoriesState.JeiCategoryState.Creator visible, JeiCategoriesState.JeiCategoryState.Creator hidden) {
        IRecipeManager recipeManager = runtime.getRecipeManager();
        Set<IRecipeCategory<?>> visibleCategories = recipeManager.createRecipeCategoryLookup().get().collect(Collectors.toSet());
        Set<IRecipeCategory<?>> hiddenCategories = UnintuitiveApiHelper.getHiddenRecipeCategories(recipeManager);
        return Stream.concat(this.stateStream(visibleCategories, visible), this.stateStream(hiddenCategories, hidden)).collect(Collectors.toSet());
    }

    private Stream<JeiCategoriesState.JeiCategoryState> stateStream(Set<IRecipeCategory<?>> categories, JeiCategoriesState.JeiCategoryState.Creator constructor) {
        return categories.stream().map(UnintuitiveApiHelper::getRecipeCategoryId).map(constructor);
    }
}

