/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.ingredient;

import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientType;
import com.blamejared.jeitweaker.common.ingredient.SimpleJeiIngredient;
import java.util.Objects;
import java.util.function.UnaryOperator;

public final class ZenOnlyJeiIngredient<J, Z>
extends SimpleJeiIngredient<J, Z> {
    private final Z zenIngredient;
    private final UnaryOperator<Z> copier;

    ZenOnlyJeiIngredient(JeiIngredientType<J, Z> type, Z zenIngredient, UnaryOperator<Z> copier) {
        super(type);
        this.zenIngredient = zenIngredient;
        this.copier = copier;
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, Z zenIngredient) {
        return ZenOnlyJeiIngredient.of(type, zenIngredient, UnaryOperator.identity());
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, Z zenIngredient, UnaryOperator<Z> copier) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(zenIngredient, "zenIngredient");
        Objects.requireNonNull(copier, "copier");
        Object storedZenIngredient = copier.apply(zenIngredient);
        Objects.requireNonNull(storedZenIngredient, "copier.apply(zenIngredient)");
        return new ZenOnlyJeiIngredient<J, Z>(type, storedZenIngredient, copier);
    }

    @Override
    public J jeiContent() {
        return this.converter().toJeiFromZen(this.zenContent());
    }

    @Override
    public Z zenContent() {
        return (Z)this.copier.apply(this.zenIngredient);
    }
}

