/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.ingredient;

import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientType;
import com.blamejared.jeitweaker.common.ingredient.SimpleJeiIngredient;
import java.util.Objects;
import java.util.function.UnaryOperator;

public final class JeiOnlyJeiIngredient<J, Z>
extends SimpleJeiIngredient<J, Z> {
    private final J jeiIngredient;
    private final UnaryOperator<J> copier;

    JeiOnlyJeiIngredient(JeiIngredientType<J, Z> type, J jeiIngredient, UnaryOperator<J> copier) {
        super(type);
        this.jeiIngredient = jeiIngredient;
        this.copier = copier;
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, J jeiIngredient) {
        return JeiOnlyJeiIngredient.of(type, jeiIngredient, UnaryOperator.identity());
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, J jeiIngredient, UnaryOperator<J> copier) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(jeiIngredient, "jeiIngredient");
        Objects.requireNonNull(copier, "copier");
        Object storedJeiIngredient = copier.apply(jeiIngredient);
        Objects.requireNonNull(storedJeiIngredient, "copier.apply(jeiIngredient)");
        return new JeiOnlyJeiIngredient<J, Z>(type, storedJeiIngredient, copier);
    }

    @Override
    public J jeiContent() {
        return (J)this.copier.apply(this.jeiIngredient);
    }

    @Override
    public Z zenContent() {
        return this.converter().toZenFromJei(this.jeiContent());
    }
}

