/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.ingredient;

import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientType;
import com.blamejared.jeitweaker.common.ingredient.SimpleJeiIngredient;
import java.util.Objects;
import java.util.function.UnaryOperator;

public final class BothJeiIngredient<J, Z>
extends SimpleJeiIngredient<J, Z> {
    private final J jeiIngredient;
    private final Z zenIngredient;
    private final UnaryOperator<J> jeiCopier;
    private final UnaryOperator<Z> zenCopier;

    private BothJeiIngredient(JeiIngredientType<J, Z> type, J jeiIngredient, UnaryOperator<J> jeiCopier, Z zenIngredient, UnaryOperator<Z> zenCopier) {
        super(type);
        this.jeiIngredient = jeiIngredient;
        this.zenIngredient = zenIngredient;
        this.jeiCopier = jeiCopier;
        this.zenCopier = zenCopier;
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, J jeiIngredient, Z zenIngredient) {
        return BothJeiIngredient.of(type, jeiIngredient, UnaryOperator.identity(), zenIngredient);
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, J jeiIngredient, UnaryOperator<J> jeiCopier, Z zenIngredient) {
        return BothJeiIngredient.of(type, jeiIngredient, jeiCopier, zenIngredient, UnaryOperator.identity());
    }

    public static <J, Z> JeiIngredient<J, Z> of(JeiIngredientType<J, Z> type, J jeiIngredient, UnaryOperator<J> jeiCopier, Z zenIngredient, UnaryOperator<Z> zenCopier) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(jeiIngredient, "jeiIngredient");
        Objects.requireNonNull(jeiCopier, "jeiCopier");
        Objects.requireNonNull(zenIngredient, "zenIngredient");
        Objects.requireNonNull(zenCopier, "zenCopier");
        Object storedJeiIngredient = jeiCopier.apply(jeiIngredient);
        Object storedZenIngredient = zenCopier.apply(zenIngredient);
        Objects.requireNonNull(storedJeiIngredient, "jeiCopier.apply(jeiIngredient)");
        Objects.requireNonNull(storedZenIngredient, "zenCopier.apply(zenIngredient)");
        return new BothJeiIngredient<J, Z>(type, storedJeiIngredient, jeiCopier, storedZenIngredient, zenCopier);
    }

    @Override
    public J jeiContent() {
        return (J)this.jeiCopier.apply(this.jeiIngredient);
    }

    @Override
    public Z zenContent() {
        return (Z)this.zenCopier.apply(this.zenIngredient);
    }
}

