/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.action;

import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.jeitweaker.common.api.action.JeiTweakerAction;
import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandTypes;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredients;
import com.blamejared.jeitweaker.common.api.zen.ingredient.ZenJeiIngredient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;

public final class HideIngredientsAction
extends JeiTweakerAction {
    private final Collection<? extends JeiIngredient<?, ?>> ingredients;

    private HideIngredientsAction(Collection<? extends JeiIngredient<?, ?>> ingredients) {
        this.ingredients = ingredients;
    }

    public static HideIngredientsAction of(ZenJeiIngredient ... ingredients) {
        Objects.requireNonNull(ingredients, "ingredients");
        List<JeiIngredient> jeiIngredients = Arrays.stream(ingredients).map(JeiIngredients::toJeiIngredient).toList();
        return new HideIngredientsAction(jeiIngredients);
    }

    public void apply() {
        this.enqueueCommand(JeiCommand.of(JeiCommandTypes.GENERAL, this::hide));
    }

    public String describe() {
        return "Hiding %s ingredients from JEI: %s".formatted(this.ingredients.size(), this.ingredients.stream().map(JeiIngredients::toCommandString).toList());
    }

    private void hide(IJeiRuntime runtime) {
        IIngredientManager manager = runtime.getIngredientManager();
        this.ingredients.stream().collect(Collectors.groupingBy(JeiIngredients::jeiIngredientTypeOf, Collectors.mapping(JeiIngredient::jeiContent, Collectors.toList()))).forEach((type, ingredient) -> this.hide(manager, (IIngredientType)GenericUtil.uncheck((Object)type), (List)GenericUtil.uncheck((Object)ingredient)));
    }

    private <J> void hide(IIngredientManager manager, IIngredientType<J> type, List<J> ingredients) {
        if (ingredients.isEmpty()) {
            return;
        }
        manager.removeIngredientsAtRuntime(type, ingredients);
    }
}

