/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AddTrainEndPacket
implements S2CPacket {
    final UUID trainId;
    final UUID backTrainId;
    final int middleSpacing;
    final boolean doubleEnded;

    public AddTrainEndPacket(Train train, Train backTrain, int middleSpacing, boolean doubleEnded) {
        this.trainId = train.id;
        this.backTrainId = backTrain.id;
        this.middleSpacing = middleSpacing;
        this.doubleEnded = doubleEnded;
    }

    public AddTrainEndPacket(FriendlyByteBuf buf) {
        this.trainId = buf.m_130259_();
        this.backTrainId = buf.m_130259_();
        this.middleSpacing = buf.readInt();
        this.doubleEnded = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.m_130077_(this.backTrainId);
        buffer.writeInt(this.middleSpacing);
        buffer.writeBoolean(this.doubleEnded);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        ClientLevel level = mc.f_91073_;
        if (level != null) {
            Train train = (Train)CreateClient.RAILWAYS.trains.get(this.trainId);
            Train backTrain = (Train)CreateClient.RAILWAYS.trains.get(this.backTrainId);
            if (train != null && backTrain != null) {
                train.carriages.addAll(backTrain.carriages);
                backTrain.carriages.clear();
                train.carriageSpacing.add(this.middleSpacing);
                train.carriageSpacing.addAll(backTrain.carriageSpacing);
                backTrain.carriageSpacing.clear();
                double[] newStress = new double[((AccessorTrain)train).snr_getStress().length + ((AccessorTrain)backTrain).snr_getStress().length + 1];
                System.arraycopy(((AccessorTrain)train).snr_getStress(), 0, newStress, 0, ((AccessorTrain)train).snr_getStress().length);
                newStress[((AccessorTrain)train).snr_getStress().length] = 0.0;
                System.arraycopy(((AccessorTrain)backTrain).snr_getStress(), 0, newStress, ((AccessorTrain)train).snr_getStress().length + 1, ((AccessorTrain)backTrain).snr_getStress().length);
                ((AccessorTrain)train).snr_setStress(newStress);
                train.doubleEnded = this.doubleEnded;
                train.carriages.forEach(c -> c.setTrain(train));
                CreateClient.RAILWAYS.trains.remove(this.backTrainId);
            }
        }
    }
}

